/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.util;

import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.service.impl.Blockades;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Listener
public class InfinispanEventListener {
    private static final long GATEWAY_CLIENT_KEEPALIVE_TIMEOUT_MS = 180000L;
    private static Logger log = Logger.getLogger(InfinispanEventListener.class);
    private GatewayDeviceConnection deviceConnection;
    private String nodeUrl;
    private Blockades blockades;
    private ConcurrentMap<String, SessionEntity> oldSessions = new ConcurrentHashMap<String, SessionEntity>();

    @Autowired
    @Required
    public void setDeviceConnection(GatewayDeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
    }

    @Value(value="${GDConnection.restUrl}")
    public void setNodeUrl(String nodeUrl) {
        this.nodeUrl = nodeUrl;
    }

    @Autowired
    @Required
    public void setBlockades(Blockades blockades) {
        this.blockades = blockades;
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<?, ?> event) {
        log.trace((Object)("modified modified(event=" + event + ")"));
        String deviceId = event.getKey().toString();
        if (event.isPre()) {
            SessionEntity oldSession = (SessionEntity)event.getValue();
            if (oldSession != null) {
                this.oldSessions.put(deviceId, (SessionEntity)event.getValue());
            }
        } else {
            SessionEntity oldValue = (SessionEntity)this.oldSessions.remove(deviceId);
            if (oldValue == null) {
                log.trace((Object)("Processing connecting a new device (" + deviceId + ")"));
                return;
            }
            GatewayDevice device = this.deviceConnection.findById(deviceId);
            if (device == null) {
                log.trace((Object)("Device " + deviceId + " is not connected to this node..."));
                return;
            }
            if (!oldValue.isDeviceConnected()) {
                log.trace((Object)("Old session of device " + deviceId + " is not connected..."));
                return;
            }
            SessionEntity newValue = (SessionEntity)event.getValue();
            if (!newValue.isDeviceConnected()) {
                log.trace((Object)("New session of device " + deviceId + " is not connected..."));
                return;
            }
            if (oldValue.equals(newValue)) {
                log.trace((Object)"Old and new sessions did not change, ignoring");
                return;
            }
            if (this.onlyRegisteredChanged(oldValue, newValue)) {
                log.trace((Object)"Only registered changed, ignoring the event");
                return;
            }
            if (!this.areSame(device, newValue)) {
                log.info((Object)("Detected duplicated HA-ID: " + deviceId));
                this.blockades.block(deviceId, device.getSerialNumber(), device.getPublicIpAddress(), newValue.getSerialNumber(), newValue.getPublicIp());
            } else if (this.deviceSwitchedServers(oldValue, newValue)) {
                log.info((Object)("Detected reconecting of device " + deviceId + " from " + oldValue.getServerUrl() + " to " + newValue.getServerUrl()));
                this.deviceConnection.deviceDisconnected(deviceId, "RECONNECT");
            }
        }
    }

    private boolean deviceWasSwapped(GatewayDevice device, SessionEntity newValue) {
        return device.publicIpAddress.equals(newValue.getPublicIp()) && device.getSerialNumber() != null && newValue.getSerialNumber() != null && !device.getSerialNumber().equals(newValue.getSerialNumber());
    }

    private boolean deviceSwitchedServers(SessionEntity oldValue, SessionEntity newValue) {
        return this.nodeUrl.equals(oldValue.getServerUrl()) && !this.nodeUrl.equals(newValue.getServerUrl());
    }

    private boolean onlyRegisteredChanged(SessionEntity oldValue, SessionEntity newValue) {
        return oldValue.getPublicIp().equals(newValue.getPublicIp()) && oldValue.getLocalIp().equals(newValue.getLocalIp()) && oldValue.getServerUrl().equals(newValue.getServerUrl()) && Utils.equalsAndNotNull(oldValue.getSerialNumber(), newValue.getSerialNumber()) && oldValue.isDeviceConnected() == newValue.isDeviceConnected() && (oldValue.getRegistered() == null || newValue.getRegistered() == null ? oldValue.getRegistered() != newValue.getRegistered() : !oldValue.getRegistered().equals(newValue.getRegistered()));
    }

    private boolean areSame(GatewayDevice device, SessionEntity session) {
        if (this.deviceWasSwapped(device, session)) {
            log.debug((Object)"Device has been swapped, will not block");
            return true;
        }
        if (this.deviceWasUpgraded(device, session)) {
            log.debug((Object)"Device has been upgraded, will not block");
            return true;
        }
        if (this.deviceWasDowngraded(device, session)) {
            log.debug((Object)"Device has been downgraded, will not block");
            return true;
        }
        if (device.getSerialNumber() == null ^ session.getSerialNumber() == null) {
            log.debug((Object)"Device has serial number and new session does not (or other way round), assuming duplicate");
            return false;
        }
        if (device.getSerialNumber() != null) {
            log.trace((Object)String.format("Comparing device and session serial numbers %s vs %s", device.getSerialNumber(), session.getSerialNumber()));
            return Utils.equalsAndNotNull(device.getSerialNumber(), session.getSerialNumber());
        }
        if (device.getPublicIpAddress().equals(session.getPublicIp())) {
            log.trace((Object)"No serial number, device and new session public IP addresses match, assuming the same device");
            return true;
        }
        return this.deviceProbablyChangingIpAddress(device);
    }

    private boolean deviceWasDowngraded(GatewayDevice device, SessionEntity session) {
        return device.getPublicIpAddress().equals(session.getPublicIp()) && device.getSerialNumber() != null && session.getSerialNumber() == null && (device.getVersionMajor() > 3 || device.getVersionMajor() == 3 && device.getVersionMinor() >= 13);
    }

    private boolean deviceWasUpgraded(GatewayDevice device, SessionEntity session) {
        return device.getPublicIpAddress().equals(session.getPublicIp()) && device.getSerialNumber() == null && session.getSerialNumber() != null && (device.getVersionMajor() < 3 || device.getVersionMajor() == 3 && device.getVersionMinor() < 13);
    }

    private boolean deviceProbablyChangingIpAddress(GatewayDevice device) {
        return System.currentTimeMillis() - device.getLastAlive() > 180000L;
    }
}

