/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.service.PortForwardingConfigurationQueue;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class PortForwardingConfigurationQueueImpl
implements PortForwardingConfigurationQueue {
    private static final Logger log = Logger.getLogger(PortForwardingConfigurationQueueImpl.class);
    private boolean isRunning = true;
    private ServiceFactory serviceFactory;
    private int workersCount;
    private LinkedBlockingDeque<Job> jobs = new LinkedBlockingDeque();

    @PostConstruct
    void startup() {
        for (int i = 0; i < this.workersCount; ++i) {
            Thread workerThread = new Thread(new Worker());
            workerThread.start();
        }
    }

    @PreDestroy
    void shutdown() {
        this.isRunning = false;
    }

    @Autowired
    @Required
    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Value(value="${UpnpPortForwarding.workersCount:50}")
    public void setWorkersCount(int workersCount) {
        this.workersCount = workersCount;
    }

    @Override
    public void add(String deviceId, Integer port) {
        this.jobs.add(new Job(deviceId, port));
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            while (PortForwardingConfigurationQueueImpl.this.isRunning) {
                Job job = null;
                try {
                    job = (Job)PortForwardingConfigurationQueueImpl.this.jobs.take();
                }
                catch (InterruptedException e) {
                    log.debug((Object)("Port forwarding configuration thread interrupted: " + e.getMessage()));
                }
                if (job == null) continue;
                try {
                    PortForwardingConfigurationQueueImpl.this.serviceFactory.getUpnpPortForwardingServiceImpl().setUpForwarding(job.deviceId, job.port);
                }
                catch (SetUpForwardingException ex) {
                    log.warn((Object)("Failed to set up port forwarding for deviceId=" + job.deviceId + " and port=" + job.port + ": " + (Object)((Object)ex.getErrorCode())));
                }
            }
        }
    }

    private class Job {
        public String deviceId;
        public Integer port;

        public Job(String deviceId, Integer port) {
            this.deviceId = deviceId;
            this.port = port;
        }
    }
}

