/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.DomainName;
import com.vestiacom.gdserver.service.DomainNameService;
import com.vestiacom.gdserver.service.DomainNameServiceException;
import com.vestiacom.gdserver.service.impl.DomainNameValue;
import com.vestiacom.gdserver.util.ExceptionsTrigger;
import com.vestiacom.util.SharedCache;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;

@Service
public class DomainNameServiceImpl
implements DomainNameService {
    private static Logger log = Logger.getLogger(DomainNameServiceImpl.class);
    private SharedCache sharedCache;
    private DaoFactory daoFactory;
    private Map<String, DomainNameValue> domainNames;

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @Autowired
    @Required
    public void setDaoFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @PostConstruct
    public void initialize() {
        this.domainNames = this.sharedCache.getMap("dns", new SharedCache.Flag[0]);
    }

    @Override
    public void add(String name, String mac, DomainName.AddressType type) throws DomainNameServiceException {
        log.trace((Object)("start add(name=" + name + ", mac=" + mac + ", type=" + (Object)((Object)type) + ")"));
        ExceptionsTrigger.throwIfNull(name, new NullPointerException("name"));
        ExceptionsTrigger.throwIfNull(mac, new NullPointerException("mac"));
        ExceptionsTrigger.throwIfNull((Object)type, new NullPointerException("type"));
        name = name.toLowerCase();
        try {
            this.domainNames.put(name, new DomainNameValue(mac, type));
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to add domain name with name=" + name + ", mac=" + mac + ", type=" + (Object)((Object)type) + ": " + ex.getMessage()));
            throw new DomainNameServiceException(ex.getMessage());
        }
    }

    @Override
    public DomainNameValue get(String name) throws DomainNameServiceException {
        log.trace((Object)("start add(name=" + name + ")"));
        ExceptionsTrigger.throwIfNull(name, new NullPointerException("name"));
        name = name.toLowerCase();
        try {
            return this.domainNames.get(name);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to get domain name with name=" + name + ": " + ex.getMessage()));
            throw new DomainNameServiceException(ex.getMessage());
        }
    }

    @Override
    public void remove(String name) throws DomainNameServiceException {
        log.trace((Object)("start remove(name=" + name + ")"));
        ExceptionsTrigger.throwIfNull(name, new NullPointerException("name"));
        name = name.toLowerCase();
        try {
            this.domainNames.remove(name);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to remove domain name with name=" + name + ": " + ex.getMessage()));
            throw new DomainNameServiceException(ex.getMessage());
        }
    }

    @Override
    public String resolve(String name) throws DomainNameServiceException {
        log.trace((Object)("start resolve(name=" + name + ")"));
        ExceptionsTrigger.throwIfNull(name, new NullPointerException("name"));
        String normalizedName = this.normalizeName(name);
        log.trace((Object)("lookup normalized: '" + normalizedName + "'"));
        DomainNameValue value = this.get(normalizedName);
        if (value == null) {
            log.debug((Object)("Not found domain name value for name='" + normalizedName + "'."));
            return null;
        }
        SessionEntity session = this.daoFactory.getSessionDao().get(value.getMac());
        if (session == null) {
            log.debug((Object)("Not session for device with mac=" + value.getMac() + "."));
            return null;
        }
        if (value.getType() == null) {
            log.error((Object)"Found null address type.");
            return null;
        }
        switch (value.getType()) {
            case PUBLIC: {
                return session.getPublicIp();
            }
            case LOCAL: {
                return session.getLocalIp();
            }
        }
        log.error((Object)("Unsupported address type: " + (Object)((Object)value.getType()) + "."));
        return null;
    }

    private String normalizeName(String name) {
        String result = name.endsWith(".") ? name.substring(0, name.length() - 1) : name;
        return result.toLowerCase();
    }
}

