/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.service.impl.Blockade;
import com.vestiacom.gdserver.util.MailGate;
import com.vestiacom.gdserver.util.Utils;
import com.vestiacom.util.SharedCache;
import homemonitor.BlockPeriodCache;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.mail.Message;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Blockades {
    private static Logger log = Logger.getLogger(Blockades.class);
    private SharedCache sharedCache;
    private ConcurrentMap<String, Blockade> blockades;
    private BlockPeriodCache blockPeriodCache;
    private String emailAddresses;
    private MailGate mailGate;
    private static final String BLOCKED_EMAIL_NOTIFICATION_SUBJECT = "Duplicated HA-ID detected";
    private static final String AUTO_UNBLOCK_NOTIFICATION_SUBJECT = "HA-ID unblocked";

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @Autowired
    @Required
    public void setBlockPeriodCache(BlockPeriodCache blockPeriodCache) {
        this.blockPeriodCache = blockPeriodCache;
    }

    @Value(value="${security.emailAddresses:}")
    public void setEmailAddresses(String emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    @Autowired
    @Required
    public void setMailGate(MailGate mailGate) {
        this.mailGate = mailGate;
    }

    @PostConstruct
    public void initialize() {
        this.blockades = this.sharedCache.getMap("blockades", new SharedCache.Flag[0]);
    }

    public Blockade block(String deviceId, String sn1, String ip1, String sn2, String ip2) {
        log.trace((Object)("start block(deviceId=" + deviceId + ")"));
        Blockade blockade = (Blockade)this.blockades.get(deviceId);
        if (blockade == null) {
            blockade = new Blockade();
        }
        blockade.block();
        blockade.addSerialNumber(sn1);
        blockade.addSerialNumber(sn2);
        this.blockades.put(deviceId, blockade);
        this.sendEmailNotification(deviceId, BLOCKED_EMAIL_NOTIFICATION_SUBJECT, this.getEmailTextBlocked(deviceId, blockade, sn1, ip1, sn2, ip2));
        return blockade;
    }

    public Blockade get(String deviceId) {
        return (Blockade)this.blockades.get(deviceId);
    }

    public void unblock(String deviceId, boolean resetBlockCount) {
        log.trace((Object)("start unblock(deviceId=" + deviceId + ")"));
        Blockade blockade = (Blockade)this.blockades.get(deviceId);
        if (blockade == null) {
            log.warn((Object)("Trying to unblock non-existent device with deviceId=" + deviceId));
            return;
        }
        blockade.unblock(resetBlockCount);
        this.blockades.put(deviceId, blockade);
    }

    public boolean isBlockOngoing(String deviceId) {
        log.trace((Object)("start isBlockOngoing(deviceId=" + deviceId + ")"));
        Blockade blockade = (Blockade)this.blockades.get(deviceId);
        return blockade != null && blockade.isBlockOngoing(this.blockPeriodCache);
    }

    public Map<String, Blockade> getActiveBlockades() {
        log.trace((Object)"start getActiveBlockades()");
        HashMap<String, Blockade> blocked = new HashMap<String, Blockade>();
        for (Map.Entry entry : this.blockades.entrySet()) {
            if (((Blockade)entry.getValue()).getBlockDate() == null) continue;
            blocked.put((String)entry.getKey(), (Blockade)entry.getValue());
        }
        return blocked;
    }

    public void releaseSerialNumber(String newDeviceId, String serialNumber) {
        Map<String, Blockade> activeBlockades = this.getActiveBlockades();
        for (Map.Entry<String, Blockade> entry : activeBlockades.entrySet()) {
            String deviceId = entry.getKey();
            Blockade blockade = entry.getValue();
            log.trace((Object)("Removing SN " + serialNumber + " from blockade for ID " + deviceId));
            if (!blockade.removeSerialNumber(serialNumber)) continue;
            log.trace((Object)("SN " + serialNumber + " has been removed for device " + deviceId + ", storing"));
            if (!blockade.didBlockDeviceWithoutSerialNumber() && blockade.getSerialNumbers().size() <= 1) {
                log.debug((Object)("Unblocking HA-ID " + deviceId + ", device with serial number " + serialNumber + " connected with new HA-ID"));
                blockade.unblock(false);
                this.sendEmailNotification(deviceId, AUTO_UNBLOCK_NOTIFICATION_SUBJECT, this.getEmailTextUnblocked(deviceId, newDeviceId, serialNumber));
            }
            this.blockades.put(deviceId, blockade);
        }
    }

    private String getEmailTextUnblocked(String deviceId, String newDeviceId, String serialNumber) {
        StringBuilder text = new StringBuilder();
        text.append("HA-ID " + deviceId + " has been unblocked after device with serial number " + serialNumber + " reconnected with different HA-ID (" + newDeviceId + ").");
        return text.toString();
    }

    private void sendEmailNotification(String haId, String subject, String text) {
        Set<String> recipients = this.getEmailAddresses();
        if (recipients.isEmpty()) {
            log.debug((Object)"Not found any recipients. Email notification about duplicated HA-ID  will not be send.");
            return;
        }
        MailGate.Message message = new MailGate.Message();
        message.setHtml(false);
        message.setSubject(subject);
        message.setText(text);
        for (String recipient : recipients) {
            message.addRecipient(Message.RecipientType.TO, recipient);
        }
        this.mailGate.send(message);
    }

    private Set<String> getEmailAddresses() {
        String[] parts;
        HashSet<String> addresses = new HashSet<String>();
        for (String part : parts = this.emailAddresses.split(",")) {
            if (Utils.isBlank(part)) continue;
            addresses.add(part);
        }
        return addresses;
    }

    private String getEmailTextBlocked(String haId, Blockade blockade, String sn1, String ip1, String sn2, String ip2) {
        StringBuilder text = new StringBuilder();
        text.append("Detected duplicated HA-ID for HA-ID ").append(haId).append(":").append(this.getNewLine());
        this.addLine(text, "Block count", "" + blockade.getBlockCount());
        this.addLine(text, "Block date", this.formatDate(blockade.getBlockDate()));
        this.addLine(text, "Block expiry date", this.getBlockadeExpiryDate(blockade));
        if (sn1 != null) {
            this.addLine(text, "Device 1 serial number", sn1);
        }
        this.addLine(text, "Device 1 public ip", ip1);
        if (sn2 != null) {
            this.addLine(text, "Device 2 serial number", sn2);
        }
        this.addLine(text, "Device 2 public ip", ip2);
        return text.toString();
    }

    private void addLine(StringBuilder builder, String key, String value) {
        builder.append(key).append(": ").append(value).append(this.getNewLine());
    }

    private String getNewLine() {
        return System.getProperty("line.separator");
    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return date == null ? "" : dateFormat.format(date);
    }

    private String getBlockadeExpiryDate(Blockade blockade) {
        long period = this.blockPeriodCache.getBlockPeriod(Integer.valueOf(blockade.getBlockCount()), BlockPeriodCache.Unit.MILLISECOND);
        return period == 0L ? "no expiry" : this.formatDate(new Date(blockade.getBlockDate().getTime() + period));
    }
}

