/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import homemonitor.BlockPeriodCache;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class Blockade
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(Blockade.class);
    private short blockCount;
    private Date blockDate;
    private Set<String> serialNumbers = new HashSet<String>();
    private boolean blockedDeviceWithoutSerialNumber = false;

    public short getBlockCount() {
        return this.blockCount;
    }

    public Date getBlockDate() {
        return this.blockDate == null ? null : new Date(this.blockDate.getTime());
    }

    public void block() {
        this.blockCount = (short)(this.blockCount + 1);
        this.blockDate = new Date();
    }

    public void unblock(boolean resetBlockCount) {
        this.blockDate = null;
        if (resetBlockCount) {
            this.blockCount = 0;
        }
    }

    public boolean isBlockOngoing(BlockPeriodCache cache) {
        log.trace((Object)("start isBlockOngoing(cache=" + cache + ") for " + this.toString()));
        if (this.blockDate == null) {
            return false;
        }
        Long period = (long)cache.getBlockPeriod(Integer.valueOf(this.blockCount), BlockPeriodCache.Unit.MILLISECOND);
        return period == 0L ? true : this.blockDate.getTime() + period > System.currentTimeMillis();
    }

    public String toString() {
        return "Blockade [blockCount=" + this.blockCount + ", blockDate=" + this.blockDate + ", blockedDeviceWithoutSerialNumber=" + this.blockedDeviceWithoutSerialNumber + ", serialNumbers=" + this.serialNumbers + "]";
    }

    public void addSerialNumber(String serialNumber) {
        if (serialNumber == null) {
            this.blockedDeviceWithoutSerialNumber = true;
        } else {
            this.serialNumbers.add(serialNumber);
        }
    }

    public boolean removeSerialNumber(String serialNumber) {
        return this.serialNumbers.remove(serialNumber);
    }

    public Set<String> getSerialNumbers() {
        return this.serialNumbers;
    }

    public boolean didBlockDeviceWithoutSerialNumber() {
        return this.blockedDeviceWithoutSerialNumber;
    }
}

