/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.service.impl.Blockades;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnection;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component
public class RestFilter
extends GenericFilterBean {
    private static Logger log = Logger.getLogger(RestFilter.class);
    private GatewayDeviceConnection deviceConnection;
    private String restUrl;
    private Blockades blockades;

    @Autowired
    @Required
    public void setDeviceConnection(GatewayDeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
    }

    @Autowired
    @Required
    @Value(value="${GDConnection.restUrl}")
    public void setServerUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    @Autowired
    @Required
    public void setBlockades(Blockades blockades) {
        this.blockades = blockades;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.isExcluded(httpRequest.getRequestURI())) {
            log.trace((Object)"Detected excluded request...");
            chain.doFilter(request, response);
            return;
        }
        String deviceId = this.getDeviceId(httpRequest.getRequestURI());
        if (deviceId == null) {
            log.warn((Object)("Not found deviceId for url=" + httpRequest.getRequestURI()));
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(404);
            return;
        }
        GatewayDevice device = this.deviceConnection.findById(deviceId);
        if (device == null) {
            log.trace((Object)("Device with deviceId=" + deviceId + " is not connected to this node."));
            String serverUrl = this.deviceConnection.getServerUrl(deviceId);
            if (serverUrl == null || serverUrl.equals(this.restUrl)) {
                log.trace((Object)("Device with deviceId=" + deviceId + " is not connected to cluster."));
                this.response(response, new Response(Response.Status.CLUSTER_NOT_CONNECTED));
            } else {
                log.trace((Object)("Device with deviceId=" + deviceId + " is (or was last time) connected to another node: " + serverUrl));
                this.response(response, new Response(serverUrl));
            }
        } else if (this.blockades.isBlockOngoing(deviceId)) {
            this.response(response, new Response(Response.Status.CLUSTER_NOT_CONNECTED));
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isExcluded(String requestUri) {
        return requestUri.endsWith("/serverUrl") || requestUri.endsWith("/registered") || requestUri.endsWith("/disconnect") || requestUri.endsWith("/unblock") || requestUri.endsWith("/batch");
    }

    private String getDeviceId(String url) {
        log.trace((Object)("start getDeviceId(url=" + url + ")"));
        if (Utils.isBlank(url)) {
            log.trace((Object)"Blank url");
            return null;
        }
        String startPattern = "/device/";
        if (!url.contains(startPattern)) {
            log.trace((Object)"Missing /device/ element in url");
            return null;
        }
        String deviceId = url.substring(url.indexOf(startPattern) + startPattern.length());
        int endPatternIndex = deviceId.indexOf("/");
        if (endPatternIndex > -1) {
            deviceId = deviceId.substring(0, endPatternIndex);
        }
        return deviceId;
    }

    private void response(ServletResponse servletResponse, Response response) throws IOException {
        servletResponse.setContentType("application/json");
        PrintWriter writer = servletResponse.getWriter();
        Gson gson = new Gson();
        writer.println(gson.toJson((Object)response));
    }
}

