/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.db.dao;

import com.vestiacom.gdserver.db.dao.SessionDao;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.util.InfinispanEventListener;
import com.vestiacom.util.SharedCache;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class SharedSessionDao
implements SessionDao {
    private static Logger log = Logger.getLogger(SharedSessionDao.class);
    private SharedCache sharedCache;
    private ConcurrentMap<String, SessionEntity> sessions;
    private InfinispanEventListener eventListener;
    private boolean blockEnabled;

    @Autowired
    @Required
    public void setSharedCache(SharedCache sharedCache) {
        this.sharedCache = sharedCache;
    }

    @Autowired
    @Required
    public void setEventListener(InfinispanEventListener eventListener) {
        this.eventListener = eventListener;
    }

    @Value(value="${security.blockEnabled:true}")
    public void setBlockEnabled(boolean blockEnabled) {
        this.blockEnabled = blockEnabled;
    }

    @PostConstruct
    public void initialize() {
        this.sessions = this.sharedCache.getMap("sessions", new SharedCache.Flag[0]);
        if (this.blockEnabled) {
            Cache cache = (Cache)this.sessions;
            cache.addListener((Object)this.eventListener);
        }
    }

    @Override
    public void store(String mac, SessionEntity session) {
        log.trace((Object)("start store(mac=" + mac + "session=" + session + ")"));
        try {
            this.sessions.put(mac, session);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to store session for mac=" + mac + ": " + ex.getMessage()));
        }
    }

    @Override
    public SessionEntity get(String mac) {
        try {
            SessionEntity session = (SessionEntity)this.sessions.get(mac);
            log.trace((Object)("get(mac=" + mac + ") -> " + session));
            return session;
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to get session for mac=" + mac + ": " + ex.getMessage()));
            return null;
        }
    }

    @Override
    public void disconnected(String mac, String serverUrl) {
        log.debug((Object)("start disconnected(" + mac + ", " + serverUrl + ")"));
        try {
            SessionEntity session = (SessionEntity)this.sessions.get(mac);
            if (session != null && serverUrl != null && serverUrl.equals(session.getServerUrl())) {
                log.debug((Object)"setting disconnected to true");
                session.setConnected(false);
                this.sessions.put(mac, session);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to disconnect session with mac=" + mac + ", serverUrl=" + serverUrl + ": " + ex.getMessage()));
        }
    }

    @Override
    public void disconnected(String serverUrl) {
    }

    @Override
    public void registered(String mac, boolean registered) {
        log.trace((Object)("start registered(mac=" + mac + ", registered=" + registered + ")"));
        try {
            SessionEntity session = (SessionEntity)this.sessions.get(mac);
            if (session == null) {
                log.warn((Object)("Trying to set registered=" + registered + " for non-existent device with mac=" + mac));
                return;
            }
            session.setRegistered(registered);
            this.sessions.put(mac, session);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to set registered=" + registered + " for session with mac=" + mac + ": " + ex.getMessage()));
        }
    }

    @Override
    public boolean isDeviceRegisterd(String mac) {
        try {
            SessionEntity session = (SessionEntity)this.sessions.get(mac);
            return session != null && session.isDeviceRegistered();
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to check if device with mac=" + mac + " is registered: " + ex.getMessage()));
            return false;
        }
    }

    @Override
    public void remove(String mac) {
        log.trace((Object)("start remove(mac=" + mac + ")"));
        try {
            this.sessions.remove(mac);
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to remove session with mac=" + mac + ": " + ex.getMessage()));
        }
    }

    @Override
    public Collection<SessionEntity> getSessions() {
        log.trace((Object)"start getSessions()");
        try {
            return this.sessions.values();
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to get sessions: " + ex.getMessage()));
            return null;
        }
    }
}

