/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.connector;

import com.google.gson.Gson;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.rest.model.Messages;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.Response;
import com.vestiacom.gdserver.util.ExceptionsTrigger;
import com.vestiacom.gdserver.util.Utils;
import homemonitor.GatewayDeviceConnection;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AppServerConnector {
    private static Logger log = Logger.getLogger(AppServerConnector.class);
    private String serverUrl;
    private boolean enabled = true;
    private boolean allowSelfSignedCertificates;
    private int connectionTimeout;
    private int socketTimeout;
    private int tryCount;
    private long trySleep;
    private long workerSleepTime;
    private int batchSize;
    private LinkedBlockingDeque<Message> messages = new LinkedBlockingDeque();
    private ClientConnectionManager connectionManager = null;
    private ClientConnectionManager selfSignedCertsConnectionManager = null;
    private GatewayDeviceConnection deviceConnection;

    @Value(value="${GDConnection.appServerRestUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl.endsWith("/") ? serverUrl.substring(0, serverUrl.length() - 1) : serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @Value(value="${AppServerConnector.enabled:true}")
    public void setServerEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Value(value="${AppServerConnector.allowSelfSignedCertificates:false}")
    public void setAllowSelfSignedCertificates(boolean allowSelfSignedCertificates) {
        this.allowSelfSignedCertificates = allowSelfSignedCertificates;
    }

    @Value(value="${AppServerConnector.connectionTimeout:0}")
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Value(value="${AppServerConnector.socketTimeout:0}")
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Value(value="${AppServerConnector.try.count:1}")
    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    @Value(value="${AppServerConnector.try.sleep[ms]:100}")
    public void setTrySleep(long trySleep) {
        this.trySleep = trySleep;
    }

    @Value(value="${worker.sleepTime:100}")
    public void setWorkerSleepTime(long workerSleepTime) {
        this.workerSleepTime = workerSleepTime;
    }

    @Value(value="${worker.batchSize:10}")
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Autowired
    @Required
    public void setDeviceConnection(GatewayDeviceConnection deviceConnection) {
        this.deviceConnection = deviceConnection;
    }

    @PostConstruct
    public void initialize() {
        if (this.enabled) {
            Worker worker = new Worker();
            worker.start();
        }
    }

    public void addMessage(Message message) {
        if (this.enabled) {
            this.messages.add(message);
        }
    }

    public int getMessagesCount() {
        return this.messages.size();
    }

    public Response get(String path, Class<? extends Response> responseClass) {
        log.debug((Object)("start get(path=" + path + ", responseClass=" + responseClass + ")"));
        if (!this.enabled) {
            return null;
        }
        return this.getAsUser(path, responseClass, null);
    }

    public String getRaw(String path) {
        if (!this.enabled) {
            return null;
        }
        return this.getRaw(path, null);
    }

    private String getRaw(String path, String sessionId) {
        String responseBody = null;
        int tries = 0;
        while (responseBody == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send GET " + path + " for " + ++tries + " time"));
            responseBody = this.getRawInternal(path, sessionId);
            if (responseBody != null) break;
            this.sleep(this.trySleep);
        }
        return responseBody;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String makeHttpRequest(HttpClient httpClient, HttpRequestBase request, String path) throws ClientProtocolException, IOException {
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)request);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        HttpEntity httpEntity = httpResponse.getEntity();
        log.trace((Object)("Got response for GET " + path + ": " + statusCode));
        if (statusCode != 200) {
            log.warn((Object)("Received response with status code " + statusCode + " for request with path " + path));
            if (httpEntity != null) {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            return null;
        }
        if (httpResponse.getEntity() == null) {
            log.warn((Object)("Received empty response body for request with path " + path));
            return null;
        }
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    private String getRawInternal(String path, String sessionId) {
        log.debug((Object)("start getRaw(path=" + path + ", sessionId=...)"));
        ExceptionsTrigger.throwIfBlank(path, new IllegalArgumentException("path is blank"));
        try {
            HttpGet httpGet = new HttpGet(this.getUrl(path));
            HttpClient httpClient = this.getHttpClient((HttpRequestBase)httpGet);
            if (sessionId != null) {
                httpGet.addHeader("Cookie", "JSESSIONID=" + sessionId);
            }
            return this.makeHttpRequest(httpClient, (HttpRequestBase)httpGet, path);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to execute GET http command with path=" + path + ": " + ex.getMessage()));
            return null;
        }
    }

    private HttpClient getHttpClient(HttpRequestBase request) throws NoSuchAlgorithmException, KeyManagementException {
        DefaultHttpClient httpClient = null;
        if (this.allowSelfSignedCertificates) {
            log.trace((Object)"Creating httpclient accepted self-signed certificates");
            if (this.selfSignedCertsConnectionManager == null) {
                X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                }}, new SecureRandom());
                SSLSocketFactory sf = new SSLSocketFactory(sslContext);
                sf.setHostnameVerifier(hostnameVerifier);
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                URI uri = request.getURI();
                log.trace((Object)("Creating httpclient for scheme=" + uri.getScheme() + " and port=" + uri.getPort()));
                if (uri.getScheme().equals("https")) {
                    schemeRegistry.register(new Scheme("https", uri.getPort(), (SchemeSocketFactory)sf));
                } else {
                    schemeRegistry.register(new Scheme("http", uri.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
                }
                this.selfSignedCertsConnectionManager = this.createConnectionManager(schemeRegistry);
            }
            httpClient = new DefaultHttpClient(this.selfSignedCertsConnectionManager);
        } else {
            log.trace((Object)"Creating default httpclient");
            if (this.connectionManager == null) {
                this.connectionManager = this.createConnectionManager(null);
            }
            httpClient = new DefaultHttpClient(this.connectionManager);
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)this.socketTimeout);
        return httpClient;
    }

    private ClientConnectionManager createConnectionManager(SchemeRegistry schemeRegistry) {
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager(schemeRegistry);
        connManager.setDefaultMaxPerRoute(200);
        connManager.setMaxTotal(200);
        return connManager;
    }

    public Response getAsUser(String path, Class<? extends Response> responseClass, String sessionId) {
        ExceptionsTrigger.throwIfNull(responseClass, new NullPointerException("responseClass"));
        try {
            Gson gson = new Gson();
            return (Response)gson.fromJson(this.getRaw(path, sessionId), responseClass);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to execute GET http command with path=" + path + ": " + ex.getMessage()));
            return null;
        }
    }

    private String getUrl(String path) {
        if (path.startsWith("/")) {
            return this.serverUrl + path;
        }
        return this.serverUrl + "/" + path;
    }

    public Response post(String path, HttpEntity entity, Class<? extends Response> responseClass) {
        log.debug((Object)("start post(path=" + path + ", entity=" + entity + ", responseClass=" + responseClass + ")"));
        ExceptionsTrigger.throwIfBlank(path, new IllegalArgumentException("path is blank"));
        ExceptionsTrigger.throwIfNull(responseClass, new NullPointerException("responseClass"));
        ExceptionsTrigger.throwIfNull(entity, new NullPointerException("entity"));
        if (!this.enabled) {
            return null;
        }
        Response response = null;
        int tries = 0;
        while (response == null && (tries < this.tryCount || this.tryCount == 0)) {
            log.trace((Object)("Trying to send POST " + path + " for " + ++tries + " time"));
            response = this.postInternal(path, entity, responseClass);
            if (response != null) break;
            this.sleep(this.trySleep);
        }
        return response;
    }

    private Response postInternal(String path, HttpEntity entity, Class<? extends Response> responseClass) {
        try {
            HttpPost httpPost = new HttpPost(this.getUrl(path));
            HttpClient httpClient = this.getHttpClient((HttpRequestBase)httpPost);
            Gson gson = new Gson();
            httpPost.setEntity(entity);
            String rawResponse = this.makeHttpRequest(httpClient, (HttpRequestBase)httpPost, path);
            if (rawResponse == null) {
                return null;
            }
            log.trace((Object)("Response body for POST " + path + ": " + rawResponse));
            return (Response)gson.fromJson(rawResponse, responseClass);
        }
        catch (Exception ex) {
            log.error((Object)("Failed to execute POST http command with path=" + path + ": " + ex.getMessage()));
            return null;
        }
    }

    class Worker
    extends Thread {
        public Worker() {
            super("Application Server connector thread");
        }

        @Override
        public void run() {
            LinkedList<Message> batch = new LinkedList<Message>();
            while (true) {
                if (batch.isEmpty()) {
                    AppServerConnector.this.messages.drainTo(batch, AppServerConnector.this.batchSize);
                }
                if (!batch.isEmpty() && this.send(batch)) {
                    batch = new LinkedList();
                }
                try {
                    Thread.sleep(AppServerConnector.this.workerSleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private boolean send(List<Message> batch) {
            Messages messages = new Messages();
            for (Message message : batch) {
                if (message.getType() == Message.Type.CONNECTED) {
                    GatewayDevice device = this.getGatewayDevice(message);
                    if (device == null) continue;
                    messages.addDevice(device);
                }
                messages.addMessage(message);
            }
            Response response = null;
            try {
                response = AppServerConnector.this.post("/internal/gd/batch", this.getEntity(messages), Response.class);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return response != null && response.getStatus() == Response.Status.SUCCESS;
        }

        private GatewayDevice getGatewayDevice(Message message) {
            return Utils.toModel(AppServerConnector.this.deviceConnection.findById(message.getMac()));
        }

        private HttpEntity getEntity(Messages messages) throws UnsupportedEncodingException {
            Gson gson = new Gson();
            return new StringEntity(gson.toJson((Object)messages), "application/json", "UTF8");
        }
    }
}

