/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.pki;

import codec.asn1.ASN1Exception;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Type;
import de.flexiprovider.api.Registry;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.NoSuchAlgorithmException;
import de.flexiprovider.api.parameters.AlgorithmParameters;
import java.io.IOException;

public class AlgorithmIdentifier
extends codec.x509.AlgorithmIdentifier {
    public AlgorithmIdentifier() {
    }

    public AlgorithmIdentifier(ASN1ObjectIdentifier oid, byte[] b) throws ASN1Exception {
        super(oid, b);
    }

    public AlgorithmIdentifier(ASN1ObjectIdentifier oid, ASN1Type params) throws ASN1Exception {
        super(oid, params);
    }

    public AlgorithmParameters getParams() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.parameters_.isOptional()) {
            return null;
        }
        if (this.parameters_.getTag() == 5 && this.parameters_.getTagClass() == 0) {
            return null;
        }
        AlgorithmParameters params = Registry.getAlgParams(this.algorithm_.toString());
        try {
            params.init(this.parameters_.getEncoded());
        }
        catch (IOException e) {
            throw new InvalidAlgorithmParameterException("Caught IOException(\"" + e.getMessage() + "\")");
        }
        catch (ASN1Exception e) {
            throw new InvalidAlgorithmParameterException("Caught ASN1Exception(\"" + e.getMessage() + "\")");
        }
        return params;
    }
}

