/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.twofish;

import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.common.util.ByteUtils;

public class TwofishKey
implements SecretKey {
    private byte[] keyBytes;

    protected TwofishKey(byte[] keyBytes) {
        this.keyBytes = ByteUtils.clone(keyBytes);
    }

    public String getAlgorithm() {
        return "Twofish";
    }

    public byte[] getEncoded() {
        return ByteUtils.clone(this.keyBytes);
    }

    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof TwofishKey)) {
            return false;
        }
        return ByteUtils.equals(this.keyBytes, ((TwofishKey)other).keyBytes);
    }

    public int hashCode() {
        int result = 1;
        int i = 0;
        while (i < this.keyBytes.length) {
            result = 31 * result + this.keyBytes[i];
            ++i;
        }
        return result;
    }
}

