/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.shacal2;

import de.flexiprovider.api.BlockCipher;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.Key;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeySpec;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.util.BigEndianConversions;
import de.flexiprovider.core.shacal2.Shacal2Key;

public class Shacal2
extends BlockCipher {
    public static final String ALG_NAME = "Shacal2";
    int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int BLOCK_SIZE = 32;
    private int[] W = new int[64];

    public String getName() {
        return ALG_NAME;
    }

    protected int getCipherBlockSize() {
        return 32;
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof Shacal2Key) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeyException("not a Shacal2 Key");
        }
        int keyLen = key.getEncoded().length;
        if (keyLen != 16 && keyLen != 24 && keyLen != 32 && keyLen != 40 && keyLen != 48 && keyLen != 64) {
            throw new InvalidKeyException("invalid key size");
        }
        return keyLen << 3;
    }

    public void keySchedule(byte[] key) {
        int i;
        byte[] buffer = new byte[64];
        int n = key.length << 3;
        if (n == 128 || n == 192 || n == 256 || n == 320 || n == 384 || n == 448) {
            i = 0;
            while (i < n >> 3) {
                buffer[i] = key[i];
                ++i;
            }
            int i2 = n >> 3;
            while (i2 < 64) {
                buffer[i2] = 0;
                ++i2;
            }
        } else if (n == 512) {
            System.arraycopy(key, 0, buffer, 0, key.length);
        }
        this.W[0] = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        this.W[1] = (buffer[4] & 0xFF) << 24 | (buffer[5] & 0xFF) << 16 | (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF;
        this.W[2] = (buffer[8] & 0xFF) << 24 | (buffer[9] & 0xFF) << 16 | (buffer[10] & 0xFF) << 8 | buffer[11] & 0xFF;
        this.W[3] = (buffer[12] & 0xFF) << 24 | (buffer[13] & 0xFF) << 16 | (buffer[14] & 0xFF) << 8 | buffer[15] & 0xFF;
        this.W[4] = (buffer[16] & 0xFF) << 24 | (buffer[17] & 0xFF) << 16 | (buffer[18] & 0xFF) << 8 | buffer[19] & 0xFF;
        this.W[5] = (buffer[20] & 0xFF) << 24 | (buffer[21] & 0xFF) << 16 | (buffer[22] & 0xFF) << 8 | buffer[23] & 0xFF;
        this.W[6] = (buffer[24] & 0xFF) << 24 | (buffer[25] & 0xFF) << 16 | (buffer[26] & 0xFF) << 8 | buffer[27] & 0xFF;
        this.W[7] = (buffer[28] & 0xFF) << 24 | (buffer[29] & 0xFF) << 16 | (buffer[30] & 0xFF) << 8 | buffer[31] & 0xFF;
        this.W[8] = (buffer[32] & 0xFF) << 24 | (buffer[33] & 0xFF) << 16 | (buffer[34] & 0xFF) << 8 | buffer[35] & 0xFF;
        this.W[9] = (buffer[36] & 0xFF) << 24 | (buffer[37] & 0xFF) << 16 | (buffer[38] & 0xFF) << 8 | buffer[39] & 0xFF;
        this.W[10] = (buffer[40] & 0xFF) << 24 | (buffer[41] & 0xFF) << 16 | (buffer[42] & 0xFF) << 8 | buffer[43] & 0xFF;
        this.W[11] = (buffer[44] & 0xFF) << 24 | (buffer[45] & 0xFF) << 16 | (buffer[46] & 0xFF) << 8 | buffer[47] & 0xFF;
        this.W[12] = (buffer[48] & 0xFF) << 24 | (buffer[49] & 0xFF) << 16 | (buffer[50] & 0xFF) << 8 | buffer[51] & 0xFF;
        this.W[13] = (buffer[52] & 0xFF) << 24 | (buffer[53] & 0xFF) << 16 | (buffer[54] & 0xFF) << 8 | buffer[55] & 0xFF;
        this.W[14] = (buffer[56] & 0xFF) << 24 | (buffer[57] & 0xFF) << 16 | (buffer[58] & 0xFF) << 8 | buffer[59] & 0xFF;
        this.W[15] = (buffer[60] & 0xFF) << 24 | (buffer[61] & 0xFF) << 16 | (buffer[62] & 0xFF) << 8 | buffer[63] & 0xFF;
        i = 16;
        while (i < 64) {
            this.W[i] = this.sigma1(this.W[i - 2]) + this.W[i - 7] + this.sigma0(this.W[i - 15]) + this.W[i - 16];
            ++i;
        }
    }

    protected void initCipherEncrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof Shacal2Key)) {
            throw new InvalidKeyException("not a Shacal2 Key");
        }
        this.keySchedule(key.getEncoded());
    }

    protected void initCipherDecrypt(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        this.initCipherEncrypt(key, params);
    }

    protected void singleBlockDecrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int a = BigEndianConversions.OS2IP(input, 0 + inOff);
        int b = BigEndianConversions.OS2IP(input, 4 + inOff);
        int c = BigEndianConversions.OS2IP(input, 8 + inOff);
        int d = BigEndianConversions.OS2IP(input, 12 + inOff);
        int e = BigEndianConversions.OS2IP(input, 16 + inOff);
        int f = BigEndianConversions.OS2IP(input, 20 + inOff);
        int g = BigEndianConversions.OS2IP(input, 24 + inOff);
        int h = BigEndianConversions.OS2IP(input, 28 + inOff);
        int i = 63;
        while (i >= 0) {
            int tmp = a;
            a = b;
            b = c;
            c = d;
            int T2 = ((a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10)) + (a & b ^ a & c ^ b & c);
            int T1 = tmp - T2;
            d = e - T1;
            e = f;
            f = g;
            g = h;
            h = T1 - ((e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7)) - (e & f ^ ~e & g) - this.K[i] - this.W[i];
            --i;
        }
        BigEndianConversions.I2OSP(a, output, 0 + outOff);
        BigEndianConversions.I2OSP(b, output, 4 + outOff);
        BigEndianConversions.I2OSP(c, output, 8 + outOff);
        BigEndianConversions.I2OSP(d, output, 12 + outOff);
        BigEndianConversions.I2OSP(e, output, 16 + outOff);
        BigEndianConversions.I2OSP(f, output, 20 + outOff);
        BigEndianConversions.I2OSP(g, output, 24 + outOff);
        BigEndianConversions.I2OSP(h, output, 28 + outOff);
    }

    protected void singleBlockEncrypt(byte[] input, int inOff, byte[] output, int outOff) {
        int a = BigEndianConversions.OS2IP(input, 0 + inOff);
        int b = BigEndianConversions.OS2IP(input, 4 + inOff);
        int c = BigEndianConversions.OS2IP(input, 8 + inOff);
        int d = BigEndianConversions.OS2IP(input, 12 + inOff);
        int e = BigEndianConversions.OS2IP(input, 16 + inOff);
        int f = BigEndianConversions.OS2IP(input, 20 + inOff);
        int g = BigEndianConversions.OS2IP(input, 24 + inOff);
        int h = BigEndianConversions.OS2IP(input, 28 + inOff);
        int i = 0;
        while (i < 64) {
            int T1 = ((e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7)) + (e & f ^ ~e & g) + h + this.K[i] + this.W[i];
            int T2 = ((a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
            ++i;
        }
        BigEndianConversions.I2OSP(a, output, 0 + outOff);
        BigEndianConversions.I2OSP(b, output, 4 + outOff);
        BigEndianConversions.I2OSP(c, output, 8 + outOff);
        BigEndianConversions.I2OSP(d, output, 12 + outOff);
        BigEndianConversions.I2OSP(e, output, 16 + outOff);
        BigEndianConversions.I2OSP(f, output, 20 + outOff);
        BigEndianConversions.I2OSP(g, output, 24 + outOff);
        BigEndianConversions.I2OSP(h, output, 28 + outOff);
    }

    private int sigma0(int x) {
        return (x >>> 7 | x << 25) ^ (x >>> 18 | x << 14) ^ x >>> 3;
    }

    private int sigma1(int x) {
        return (x >>> 17 | x << 15) ^ (x >>> 19 | x << 13) ^ x >>> 10;
    }
}

