/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.rbrsa;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.keys.KeyPair;
import de.flexiprovider.api.keys.KeyPairGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.core.rbrsa.RbRSAKeyGenParameterSpec;
import de.flexiprovider.core.rsa.RSAPrivateCrtKey;
import de.flexiprovider.core.rsa.RSAPublicKey;

public class RbRSAKeyPairGenerator
extends KeyPairGenerator {
    private static final int CERTAINTY = 80;
    private static final FlexiBigInt TWO = FlexiBigInt.valueOf(2L);
    private int keySize;
    private int s;
    private SecureRandom random;
    private boolean initialized;

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        RbRSAKeyGenParameterSpec rsaParams;
        if (params == null) {
            rsaParams = new RbRSAKeyGenParameterSpec();
        } else if (params instanceof RbRSAKeyGenParameterSpec) {
            rsaParams = (RbRSAKeyGenParameterSpec)params;
        } else {
            throw new InvalidAlgorithmParameterException("unsupported type");
        }
        this.keySize = rsaParams.getKeySize();
        this.s = rsaParams.getPrivExpSize();
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public void initialize(int keySize, SecureRandom random) {
        RbRSAKeyGenParameterSpec params = new RbRSAKeyGenParameterSpec();
        try {
            this.initialize(params, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    private void initializeDefault() {
        RbRSAKeyGenParameterSpec defaultParams = new RbRSAKeyGenParameterSpec();
        try {
            this.initialize(defaultParams, Registry.getSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("internal error");
        }
    }

    public KeyPair genKeyPair() {
        FlexiBigInt phi;
        FlexiBigInt d;
        FlexiBigInt dq;
        FlexiBigInt dp;
        FlexiBigInt q;
        FlexiBigInt p;
        FlexiBigInt n;
        if (!this.initialized) {
            this.initializeDefault();
        }
        int bitsp = this.keySize + 1 >> 1;
        int bitsq = this.keySize - bitsp;
        do {
            p = new FlexiBigInt(bitsp, 80, this.random);
            while (p.equals(q = new FlexiBigInt(bitsq, 80, this.random)) || !p.subtract(FlexiBigInt.ONE).gcd(q.subtract(FlexiBigInt.ONE)).equals(TWO)) {
            }
        } while ((n = p.multiply(q)).bitLength() != this.keySize);
        FlexiBigInt pm = p.subtract(FlexiBigInt.ONE);
        FlexiBigInt qm = q.subtract(FlexiBigInt.ONE);
        while (true) {
            if ((dp = new FlexiBigInt(this.s, 80, this.random)).gcd(pm).intValue() != 1) {
                continue;
            }
            FlexiBigInt r = dp.mod(TWO);
            while ((dq = new FlexiBigInt(this.s, 80, this.random)).gcd(qm).intValue() != 1 || dq.mod(TWO).intValue() != r.intValue()) {
            }
            FlexiBigInt m1 = pm.divide(TWO);
            FlexiBigInt m2 = qm.divide(TWO);
            FlexiBigInt a1 = dp.subtract(r).divide(TWO);
            FlexiBigInt a2 = dq.subtract(r).divide(TWO);
            FlexiBigInt m = m1.multiply(m2);
            FlexiBigInt tmp = m2.modInverse(m1).multiply(m2).multiply(a1).mod(m);
            d = (tmp = tmp.add(m1.modInverse(m2).multiply(m1).multiply(a2).mod(m))).multiply(TWO).add(r);
            if (d.gcd(phi = pm.multiply(qm)).equals(FlexiBigInt.ONE)) break;
        }
        FlexiBigInt e = d.modInverse(phi);
        FlexiBigInt crt = q.modInverse(p);
        RSAPublicKey pubKey = new RSAPublicKey(n, e);
        RSAPrivateCrtKey privKey = new RSAPrivateCrtKey(n, d, e, p, q, dp, dq, crt);
        return new KeyPair(pubKey, privKey);
    }
}

