/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.random;

import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.SeedGenerator;

public final class BBSRandom
extends SecureRandom {
    private static final int SECURITY_PARAMETER = 1024;
    private final int CERTAINTY = 10;
    private static final FlexiBigInt CONST_2 = FlexiBigInt.valueOf(2L);
    private static final FlexiBigInt CONST_3 = FlexiBigInt.valueOf(3L);
    private static final FlexiBigInt CONST_4 = FlexiBigInt.valueOf(4L);
    private static final FlexiBigInt CONST_5 = FlexiBigInt.valueOf(5L);
    private static final FlexiBigInt CONST_7 = FlexiBigInt.valueOf(7L);
    private static final FlexiBigInt CONST_11 = FlexiBigInt.valueOf(11L);
    private static final FlexiBigInt CONST_13 = FlexiBigInt.valueOf(13L);
    private static final FlexiBigInt CONST_17 = FlexiBigInt.valueOf(17L);
    private static final FlexiBigInt CONST_19 = FlexiBigInt.valueOf(19L);
    private static final FlexiBigInt CONST_23 = FlexiBigInt.valueOf(23L);
    private final FlexiBigInt LCG_MODULUS = new FlexiBigInt("805464911080722516417453601008791849136329615762701082177197");
    private final FlexiBigInt LCG_A = new FlexiBigInt("7129718823414295026033436596773772714578900265841170538826");
    private final FlexiBigInt LCG_B = new FlexiBigInt("675276940120214627441986171104851609581303133674533034328917");
    private final int LCG_BYTE_SIZE = 25;
    private int bitsPerRound = 0;
    private FlexiBigInt n;
    private FlexiBigInt p;
    private FlexiBigInt q;
    private FlexiBigInt x = null;
    private FlexiBigInt seed = null;
    private SeedGenerator seedGenerator = new SeedGenerator();
    private boolean isSeeded = false;
    private boolean parametersGenerated = false;

    public BBSRandom() {
        int i = 0;
        while (i < 32) {
            if ((0x400 & 1 << i) != 0) {
                this.bitsPerRound = i;
            }
            ++i;
        }
    }

    public byte[] generateSeed(int numBytes) {
        return this.seedGenerator.generateSeed(numBytes);
    }

    public void nextBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        int numBits = bytes.length << 3;
        int aktResultBit = 1;
        int aktResultByte = 0;
        int aktSourceBit = 0;
        int aktResult = 0;
        if (!this.isSeeded) {
            this.selfSeed();
        }
        if (!this.parametersGenerated) {
            this.generateParameters();
        }
        bytes[0] = 0;
        do {
            if (this.x.testBit(aktSourceBit++)) {
                int n = aktResultByte;
                bytes[n] = (byte)(bytes[n] + aktResultBit);
            }
            aktResultBit <<= 1;
            if (aktSourceBit == this.bitsPerRound) {
                aktSourceBit = 0;
                this.x = this.x.multiply(this.x).mod(this.n);
            }
            if (aktResultBit != 256) continue;
            aktResultBit = 1;
            if (++aktResultByte >= bytes.length) continue;
            bytes[aktResultByte] = 0;
        } while (++aktResult < numBits);
    }

    public void setSeed(byte[] newSeed) {
        if (this.isSeeded) {
            this.seed = this.seed.xor(new FlexiBigInt(1, newSeed)).mod(this.LCG_MODULUS);
        } else {
            this.seed = new FlexiBigInt(1, newSeed).mod(this.LCG_MODULUS);
            this.isSeeded = true;
        }
        this.parametersGenerated = false;
    }

    private void generateParameters() {
        int add;
        int pBL = 512;
        int qBL = 1 + pBL;
        byte[] buf = this.lcg(pBL - 2);
        this.p = new FlexiBigInt(1, buf);
        this.p = this.p.shiftLeft(1);
        this.p = this.p.setBit(pBL - 1);
        this.p = this.p.setBit(0);
        if (this.p.mod(CONST_4).compareTo(CONST_3) != 0) {
            this.p = this.p.add(CONST_2);
        }
        int zmod3 = this.p.mod(CONST_3).intValue();
        int zmod5 = this.p.mod(CONST_5).intValue();
        int zmod7 = this.p.mod(CONST_7).intValue();
        int zmod11 = this.p.mod(CONST_11).intValue();
        int zmod13 = this.p.mod(CONST_13).intValue();
        int zmod17 = this.p.mod(CONST_17).intValue();
        int zmod19 = this.p.mod(CONST_19).intValue();
        int zmod23 = this.p.mod(CONST_23).intValue();
        while (!this.p.isProbablePrime(10)) {
            add = 0;
            do {
                add += 4;
                zmod3 = (zmod3 + 4) % 3;
                zmod5 = (zmod5 + 4) % 5;
                zmod7 = (zmod7 + 4) % 7;
                zmod11 = (zmod11 + 4) % 11;
                zmod13 = (zmod13 + 4) % 13;
                zmod17 = (zmod17 + 4) % 17;
                zmod19 = (zmod19 + 4) % 19;
                zmod23 = (zmod23 + 4) % 23;
            } while (zmod3 == 0 || zmod5 == 0 || zmod7 == 0 || zmod11 == 0 || zmod13 == 0 || zmod17 == 0 || zmod19 == 0 || zmod23 == 0);
            this.p = this.p.add(FlexiBigInt.valueOf(add));
        }
        do {
            buf = this.lcg(qBL - 2);
            this.q = new FlexiBigInt(1, buf);
            this.q = this.q.shiftLeft(1);
            this.q = this.q.setBit(0);
            this.q = this.q.setBit(qBL - 1);
            if (this.q.mod(CONST_4).compareTo(CONST_3) != 0) {
                this.q = this.q.add(CONST_2);
            }
            zmod3 = this.q.mod(CONST_3).intValue();
            zmod5 = this.q.mod(CONST_5).intValue();
            zmod7 = this.q.mod(CONST_7).intValue();
            zmod11 = this.q.mod(CONST_11).intValue();
            zmod13 = this.q.mod(CONST_13).intValue();
            zmod17 = this.q.mod(CONST_17).intValue();
            zmod19 = this.q.mod(CONST_19).intValue();
            zmod23 = this.q.mod(CONST_23).intValue();
            while (!this.q.isProbablePrime(10)) {
                add = 0;
                do {
                    add += 4;
                    zmod3 = (zmod3 + 4) % 3;
                    zmod5 = (zmod5 + 4) % 5;
                    zmod7 = (zmod7 + 4) % 7;
                    zmod11 = (zmod11 + 4) % 11;
                    zmod13 = (zmod13 + 4) % 13;
                    zmod17 = (zmod17 + 4) % 17;
                    zmod19 = (zmod19 + 4) % 19;
                    zmod23 = (zmod23 + 4) % 23;
                } while (zmod3 == 0 || zmod5 == 0 || zmod7 == 0 || zmod11 == 0 || zmod13 == 0 || zmod17 == 0 || zmod19 == 0 || zmod23 == 0);
                this.q = this.q.add(FlexiBigInt.valueOf(add));
            }
            this.n = this.p.multiply(this.q);
        } while (this.q.compareTo(this.p) == 0);
        do {
            buf = this.lcg(this.n.bitLength());
            this.x = new FlexiBigInt(1, buf).mod(this.n);
        } while (this.x.compareTo(FlexiBigInt.ZERO) == 0 || this.x.compareTo(this.p) == 0 || this.x.compareTo(this.q) == 0);
        this.parametersGenerated = true;
    }

    private byte[] lcg(int bitLength) {
        int j;
        byte[] result = new byte[bitLength + 7 >> 3];
        int leftBits = bitLength & 7;
        int i = result.length - 1;
        while (i >= result.length - (bitLength >> 3)) {
            result[i] = 0;
            j = 1;
            while (j < 256) {
                if (this.seed.testBit(0)) {
                    int n = i;
                    result[n] = (byte)(result[n] | j);
                }
                this.seed = this.LCG_A.add(this.LCG_B.multiply(this.seed)).mod(this.LCG_MODULUS);
                j <<= 1;
            }
            --i;
        }
        if (i == 0) {
            j = 0;
            while (j < leftBits) {
                if (this.seed.testBit(0)) {
                    int n = i;
                    result[n] = (byte)(result[n] | 1 << j);
                } else {
                    int n = i;
                    result[n] = (byte)(result[n] & 255 - (1 << j));
                }
                this.seed = this.LCG_A.add(this.LCG_B.multiply(this.seed)).mod(this.LCG_MODULUS);
                ++j;
            }
            j = leftBits;
            while (j < 8) {
                int n = i;
                result[n] = (byte)(result[n] & 255 - (1 << j));
                ++j;
            }
        }
        return result;
    }

    private void selfSeed() {
        this.seed = new FlexiBigInt(1, this.seedGenerator.generateSeed(25));
        this.isSeeded = true;
    }
}

