/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.Registry;
import de.flexiprovider.api.SecureRandom;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.keys.SecretKeyGenerator;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.mac.HMacKey;

public class HMacKeyGenerator
extends SecretKeyGenerator {
    private int keySize;
    private SecureRandom random;
    private boolean initialized;

    protected HMacKeyGenerator(int keySize) {
        this.keySize = keySize;
    }

    public void init(AlgorithmParameterSpec params, SecureRandom random) {
        this.init(random);
    }

    public void init(int keySize, SecureRandom random) {
        this.init(random);
    }

    public void init(SecureRandom random) {
        this.random = random != null ? random : Registry.getSecureRandom();
        this.initialized = true;
    }

    public SecretKey generateKey() {
        if (!this.initialized) {
            this.init(Registry.getSecureRandom());
        }
        byte[] keyBytes = new byte[this.keySize >> 3];
        this.random.nextBytes(keyBytes);
        return new HMacKey(keyBytes);
    }

    public static class FORK256
    extends HMacKeyGenerator {
        public FORK256() {
            super(64);
        }
    }

    public static class DHA256
    extends HMacKeyGenerator {
        public DHA256() {
            super(64);
        }
    }

    public static class Tiger
    extends HMacKeyGenerator {
        public Tiger() {
            super(64);
        }
    }

    public static class RIPEMD320
    extends HMacKeyGenerator {
        public RIPEMD320() {
            super(64);
        }
    }

    public static class RIPEMD256
    extends HMacKeyGenerator {
        public RIPEMD256() {
            super(64);
        }
    }

    public static class RIPEMD160
    extends HMacKeyGenerator {
        public RIPEMD160() {
            super(64);
        }
    }

    public static class RIPEMD128
    extends HMacKeyGenerator {
        public RIPEMD128() {
            super(64);
        }
    }

    public static class MD5
    extends HMacKeyGenerator {
        public MD5() {
            super(64);
        }
    }

    public static class MD4
    extends HMacKeyGenerator {
        public MD4() {
            super(64);
        }
    }

    public static class SHA512
    extends HMacKeyGenerator {
        public SHA512() {
            super(128);
        }
    }

    public static class SHA384
    extends HMacKeyGenerator {
        public SHA384() {
            super(128);
        }
    }

    public static class SHA256
    extends HMacKeyGenerator {
        public SHA256() {
            super(64);
        }
    }

    public static class SHA224
    extends HMacKeyGenerator {
        public SHA224() {
            super(64);
        }
    }

    public static class SHA1
    extends HMacKeyGenerator {
        public SHA1() {
            super(64);
        }
    }
}

