/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.core.mac;

import de.flexiprovider.api.Mac;
import de.flexiprovider.api.MessageDigest;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import de.flexiprovider.core.mac.HMacKey;

public class HMac
extends Mac {
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private int L;
    private int B;
    private byte[] macKey;
    private byte[] ipadKey;
    private byte[] opadKey;
    private MessageDigest md;

    HMac(MessageDigest md, int blockSize) {
        this.md = md;
        this.L = md.getDigestLength();
        this.B = blockSize;
    }

    public int getMacLength() {
        return this.L;
    }

    public void init(SecretKey key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (!(key instanceof HMacKey)) {
            throw new InvalidKeyException("unsupported type");
        }
        byte[] keyBytes = ((HMacKey)key).getEncoded();
        this.macKey = new byte[this.B];
        if (keyBytes.length <= this.B) {
            System.arraycopy(keyBytes, 0, this.macKey, 0, keyBytes.length);
        } else {
            this.md.update(keyBytes);
            byte[] keyDigest = this.md.digest();
            System.arraycopy(keyDigest, 0, this.macKey, 0, keyDigest.length);
        }
        this.ipadKey = new byte[this.B];
        this.opadKey = new byte[this.B];
        int i = this.B - 1;
        while (i >= 0) {
            this.ipadKey[i] = (byte)(this.macKey[i] ^ 0x36);
            this.opadKey[i] = (byte)(this.macKey[i] ^ 0x5C);
            --i;
        }
        this.md.update(this.ipadKey);
    }

    public void update(byte[] input, int inOff, int inLen) {
        this.md.update(input, inOff, inLen);
    }

    public void update(byte input) {
        this.md.update(input);
    }

    public byte[] doFinal() {
        byte[] hash1 = this.md.digest();
        this.md.update(this.opadKey);
        this.md.update(hash1);
        return this.md.digest();
    }

    public void reset() {
        this.md.reset();
    }

    public static class FORK256
    extends HMac {
        public FORK256() {
            super(new de.flexiprovider.core.md.FORK256(), 64);
        }
    }

    public static class DHA256
    extends HMac {
        public DHA256() {
            super(new de.flexiprovider.core.md.DHA256(), 64);
        }
    }

    public static class Tiger
    extends HMac {
        public static final String OID = "1.3.6.1.5.5.8.1.3";

        public Tiger() {
            super(new de.flexiprovider.core.md.Tiger(), 64);
        }
    }

    public static class RIPEMD320
    extends HMac {
        public RIPEMD320() {
            super(new de.flexiprovider.core.md.RIPEMD320(), 64);
        }
    }

    public static class RIPEMD256
    extends HMac {
        public RIPEMD256() {
            super(new de.flexiprovider.core.md.RIPEMD256(), 64);
        }
    }

    public static class RIPEMD160
    extends HMac {
        public static final String OID = "1.3.6.1.5.5.8.1.4";

        public RIPEMD160() {
            super(new de.flexiprovider.core.md.RIPEMD160(), 64);
        }
    }

    public static class RIPEMD128
    extends HMac {
        public RIPEMD128() {
            super(new de.flexiprovider.core.md.RIPEMD128(), 64);
        }
    }

    public static class MD5
    extends HMac {
        public static final String OID = "1.3.6.1.5.5.8.1.1";

        public MD5() {
            super(new de.flexiprovider.core.md.MD5(), 64);
        }
    }

    public static class MD4
    extends HMac {
        public MD4() {
            super(new de.flexiprovider.core.md.MD4(), 64);
        }
    }

    public static class SHA512
    extends HMac {
        public SHA512() {
            super(new de.flexiprovider.core.md.SHA512(), 128);
        }
    }

    public static class SHA384
    extends HMac {
        public SHA384() {
            super(new de.flexiprovider.core.md.SHA384(), 128);
        }
    }

    public static class SHA256
    extends HMac {
        public SHA256() {
            super(new de.flexiprovider.core.md.SHA256(), 64);
        }
    }

    public static class SHA224
    extends HMac {
        public SHA224() {
            super(new de.flexiprovider.core.md.SHA224(), 64);
        }
    }

    public static class SHA1
    extends HMac {
        public static final String OID = "1.3.6.1.5.5.8.1.2";
        public static final String PKCS5_OID = "1.2.840.113549.2.7";

        public SHA1() {
            super(new de.flexiprovider.core.md.SHA1(), 64);
        }
    }
}

