/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.math.ellipticcurves;

import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGF2n;
import de.flexiprovider.common.math.ellipticcurves.EllipticCurveGFP;
import de.flexiprovider.common.math.ellipticcurves.Point;
import de.flexiprovider.common.math.ellipticcurves.PointGF2n;
import de.flexiprovider.common.math.ellipticcurves.PointGFP;
import de.flexiprovider.common.math.finitefields.GF2nElement;
import de.flexiprovider.common.math.finitefields.GF2nField;
import de.flexiprovider.common.math.finitefields.GF2nONBElement;
import de.flexiprovider.common.math.finitefields.GF2nONBField;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialElement;
import de.flexiprovider.common.math.finitefields.GF2nPolynomialField;
import de.flexiprovider.common.math.finitefields.GFPElement;

public final class ScalarMult {
    private ScalarMult() {
    }

    public static Point multiply(FlexiBigInt b, Point p) {
        int w = 4;
        int[] N = ScalarMult.determineNaf(b, w);
        Point[] P = ScalarMult.precomputationCMO(p, w + 1, 0);
        Point R = ScalarMult.eval_SquareMultiply(N, P);
        return R;
    }

    public static Point multiply2(FlexiBigInt b, Point p) {
        int w = 4;
        int[] N = ScalarMult.determineNaf(b, w);
        Point[] P = ScalarMult.precomputation(p, w + 1, 0);
        Point R = ScalarMult.eval_SquareMultiply(N, P);
        return R;
    }

    public static Point multiply3(FlexiBigInt b, Point p) {
        int w = 4;
        int[] N = ScalarMult.determineSW(b, w);
        Point[] P = ScalarMult.precomputationCMO(p, w + 1, 0);
        Point R = ScalarMult.eval_SquareMultiply(N, P);
        return R;
    }

    public static Point multiply4(FlexiBigInt b, PointGFP p) {
        int w = 3;
        int[] N = ScalarMult.determineNaf(b, w);
        Point[] P = ScalarMult.precomputationDOS(p, 1 << w - 1);
        Point R = ScalarMult.eval_SquareMultiply(N, P);
        return R;
    }

    public static Point multiply(FlexiBigInt[] b, Point[] p) {
        int w = 5;
        int[] W = new int[b.length];
        int i = 0;
        while (i < W.length) {
            W[i] = w;
            ++i;
        }
        int[][] N = ScalarMult.determineSimultaneousNaf(b, W);
        Point[][] P = new Point[b.length][1 << w - 1];
        int i2 = 0;
        while (i2 < b.length) {
            P[i2] = ScalarMult.precomputationCMO(p[i2], w + 1, 0);
            ++i2;
        }
        Point R = ScalarMult.eval_interleaving(N, P);
        return R;
    }

    public static Point multiply2(FlexiBigInt[] b, Point[] p) {
        int w = 4;
        int[] W = new int[b.length];
        int i = 0;
        while (i < W.length) {
            W[i] = w;
            ++i;
        }
        int[][] N = ScalarMult.determineSimultaneousNaf(b, W);
        Point[][] P = new Point[b.length][1 << w - 1];
        int i2 = 0;
        while (i2 < b.length) {
            P[i2] = ScalarMult.precomputation(p[i2], w + 1, 0);
            ++i2;
        }
        Point R = ScalarMult.eval_interleaving(N, P);
        return R;
    }

    public static Point multiply3(FlexiBigInt[] b, Point[] p) {
        int w = 4;
        int bitlength = 0;
        int i = 0;
        while (i < b.length) {
            bitlength = bitlength < b[i].bitLength() ? b[i].bitLength() : bitlength;
            ++i;
        }
        int[][] N = new int[b.length][bitlength + 1];
        int i2 = 0;
        while (i2 < b.length) {
            N[i2] = ScalarMult.determineSW(b[i2], w);
            ++i2;
        }
        Point[][] P = new Point[b.length][1 << w - 1];
        int i3 = 0;
        while (i3 < b.length) {
            P[i3] = ScalarMult.precomputationCMO(p[i3], w + 1, 0);
            ++i3;
        }
        Point R = ScalarMult.eval_interleaving(N, P);
        return R;
    }

    public static Point multiply4(FlexiBigInt[] b, PointGFP[] p) {
        int w = 3;
        int[] W = new int[b.length];
        int i = 0;
        while (i < W.length) {
            W[i] = w;
            ++i;
        }
        int[][] N = ScalarMult.determineSimultaneousNaf(b, W);
        Point[][] P = new Point[b.length][1 << w - 1];
        int i2 = 0;
        while (i2 < b.length) {
            P[i2] = ScalarMult.precomputationDOS(p[i2], 1 << w - 1);
            ++i2;
        }
        Point R = ScalarMult.eval_interleaving(N, P);
        return R;
    }

    public static Point[] pre_allpowers(Point p, int w) {
        int l = (1 << w) - 1;
        Point[] P = new Point[l];
        P[0] = (Point)p.clone();
        int t = 1 << w - 1;
        int i = 1;
        while (i < t) {
            int j = i << 1;
            P[j - 1] = P[i - 1].multiplyBy2();
            P[j] = P[j - 1].add(p);
            ++i;
        }
        return P;
    }

    public static Point[] pre_oddpowers(Point p, int w) {
        int l = (1 << w) - 1;
        Point[] P = new Point[l];
        P[0] = (Point)p.clone();
        Point tmp = p.multiplyBy2();
        int i = 1;
        while (i < l) {
            P[i] = P[i - 1].add(tmp);
            ++i;
        }
        return P;
    }

    public static Point[][] pre_oddpowers(Point[] Q, int[] W) {
        int w = 0;
        int i = 0;
        while (i < W.length) {
            w = w < W[i] ? W[i] : w;
            ++i;
        }
        int l1 = Q.length;
        int l = 1 << w - 1;
        Point[][] P = ScalarMult.createPointMatrix(Q[0], Q[0], l1, l);
        int j = 0;
        while (j < l1) {
            P[j][0] = Q[j];
            Point q2 = Q[j].multiplyBy2();
            int i2 = 1;
            while (i2 < l) {
                P[j][i2] = P[j][i2 - 1].add(q2);
                ++i2;
            }
            ++j;
        }
        return P;
    }

    public static Point[] precomputation(Point p, int w, int k) {
        int length = 1;
        if (w != 0 && k == 0) {
            length = 1 << --w - 1;
        }
        if (w == 0 && k != 0) {
            length = k;
            int bits = Integer.toBinaryString(k - 1).length();
            w = bits + 1;
        }
        Point[] P = new Point[length];
        P[0] = (Point)p.clone();
        if (w <= 1) {
            return P;
        }
        Point tmp = p.multiplyBy2Affine();
        int i = 1;
        while (i < length) {
            P[i] = P[i - 1].addAffine(tmp);
            ++i;
        }
        return P;
    }

    public static Point[] precomputationCMO(Point p, int w, int k) {
        if (p instanceof PointGFP) {
            return ScalarMult.precomputationCMO((PointGFP)p, w, k);
        }
        if (p instanceof PointGF2n) {
            if (w != 0) {
                return ScalarMult.precomputationCMO((PointGF2n)p, w);
            }
            throw new RuntimeException("PrecomputationCMO on EllipticCurveGF2n with k != 0 is not supported.");
        }
        throw new RuntimeException("Point must be an instance of PointGFP / PointGF2n and windowsize must be at least 2.");
    }

    public static Point[] precomputationCMO(PointGFP p, int w, int k) {
        int denoms;
        int length;
        if (w > 2 && k == 0) {
            length = 1 << --w - 1;
            denoms = 1 << w - 2;
        } else if (w == 0 && k > 1) {
            length = k;
            int bits = Integer.toBinaryString(k - 1).length();
            w = bits + 1;
            denoms = 1 << bits - 1;
        } else {
            Point[] P = new Point[]{(PointGFP)p.clone()};
            return P;
        }
        Point[] P = new Point[length];
        P[0] = (PointGFP)p.clone();
        PointGFP doubleP = (PointGFP)p.multiplyBy2Affine();
        doubleP = (PointGFP)doubleP.getAffin();
        FlexiBigInt[] NennerLambda = new FlexiBigInt[denoms];
        FlexiBigInt[] NennerLambdaInvers = new FlexiBigInt[denoms];
        FlexiBigInt invers = null;
        FlexiBigInt mP = p.getE().getQ();
        int i = 1;
        while (i < w) {
            FlexiBigInt y;
            int m;
            int m2;
            int j;
            int begin = 1 << i - 1;
            int end = (1 << i) - 1;
            boolean notLastStep = i + 1 != w;
            int start = 0;
            if (notLastStep) {
                j = begin;
                while (j <= end) {
                    NennerLambda[start] = doubleP.getX().toFlexiBigInt().subtract(((PointGFP)P[start]).getX().toFlexiBigInt());
                    ++start;
                    ++j;
                }
                NennerLambda[start] = doubleP.getY().toFlexiBigInt().add(doubleP.getY().toFlexiBigInt()).mod(mP);
                NennerLambdaInvers[0] = NennerLambda[0].add(FlexiBigInt.ZERO);
                m2 = 1;
                while (m2 <= begin) {
                    NennerLambdaInvers[m2] = NennerLambdaInvers[m2 - 1].multiply(NennerLambda[m2]).mod(mP);
                    ++m2;
                }
                invers = NennerLambdaInvers[begin].modInverse(mP);
                m = begin;
                while (m >= 1) {
                    NennerLambdaInvers[m] = NennerLambdaInvers[m - 1].multiply(invers).mod(mP);
                    invers = invers.multiply(NennerLambda[m]).mod(mP);
                    --m;
                }
                NennerLambdaInvers[0] = invers;
            } else {
                j = begin;
                while (j <= end) {
                    NennerLambda[start] = doubleP.getX().toFlexiBigInt().subtract(((PointGFP)P[start]).getX().toFlexiBigInt());
                    ++start;
                    ++j;
                }
                NennerLambdaInvers[0] = NennerLambda[0].add(FlexiBigInt.ZERO);
                m2 = 1;
                while (m2 < begin) {
                    NennerLambdaInvers[m2] = NennerLambdaInvers[m2 - 1].multiply(NennerLambda[m2]).mod(mP);
                    ++m2;
                }
                invers = NennerLambdaInvers[begin - 1].modInverse(mP);
                m = begin - 1;
                while (m >= 1) {
                    NennerLambdaInvers[m] = NennerLambdaInvers[m - 1].multiply(invers).mod(mP);
                    invers = invers.multiply(NennerLambda[m]).mod(mP);
                    --m;
                }
                NennerLambdaInvers[0] = invers;
            }
            FlexiBigInt lambda = null;
            FlexiBigInt temp = null;
            start = 0;
            int j2 = begin;
            while (j2 <= end) {
                FlexiBigInt startX = ((PointGFP)P[start]).getX().toFlexiBigInt();
                FlexiBigInt startY = ((PointGFP)P[start]).getY().toFlexiBigInt();
                lambda = doubleP.getY().toFlexiBigInt().subtract(startY);
                lambda = NennerLambdaInvers[start].multiply(lambda).mod(mP);
                temp = lambda.multiply(lambda).mod(mP);
                temp = temp.subtract(startX);
                FlexiBigInt x = temp.subtract(doubleP.getX().toFlexiBigInt()).mod(mP);
                temp = startX.subtract(x);
                temp = lambda.multiply(temp).mod(mP);
                y = temp.subtract(startY).mod(mP);
                GFPElement gfpx = new GFPElement(x, mP);
                GFPElement gfpy = new GFPElement(y, mP);
                P[j2] = new PointGFP(gfpx, gfpy, (EllipticCurveGFP)p.getE());
                if (k == j2 + 1) {
                    return P;
                }
                ++start;
                ++j2;
            }
            if (notLastStep) {
                lambda = doubleP.getX().toFlexiBigInt().multiply(doubleP.getX().toFlexiBigInt()).mod(mP);
                lambda = lambda.multiply(new FlexiBigInt(Integer.toString(3))).mod(mP);
                lambda = lambda.add(doubleP.getE().getA().toFlexiBigInt());
                lambda = lambda.multiply(NennerLambdaInvers[start]).mod(mP);
                temp = doubleP.getX().toFlexiBigInt().add(doubleP.getX().toFlexiBigInt()).mod(mP);
                FlexiBigInt x = lambda.multiply(lambda).mod(mP).subtract(temp);
                temp = doubleP.getX().toFlexiBigInt().subtract(x);
                temp = lambda.multiply(temp).mod(mP);
                y = temp.subtract(doubleP.getY().toFlexiBigInt());
                doubleP = new PointGFP(new GFPElement(x, mP), new GFPElement(y, mP), new GFPElement(FlexiBigInt.ONE, mP), (EllipticCurveGFP)doubleP.getE());
            }
            ++i;
        }
        return P;
    }

    public static Point[] precomputationCMO(PointGF2n p, int w) {
        int length = 1 << --w - 1;
        int denoms = 1 << w - 2;
        Point[] P = new Point[length];
        P[0] = (PointGF2n)p.clone();
        if (w <= 1) {
            return P;
        }
        PointGF2n doubleP = (PointGF2n)p.multiplyBy2Affine();
        doubleP = (PointGF2n)doubleP.getAffin();
        GF2nElement[] NennerLambda = new GF2nElement[denoms];
        GF2nElement[] NennerLambdaInvers = new GF2nElement[denoms];
        GF2nElement invers = null;
        int i = 1;
        while (i < w) {
            GF2nElement y;
            int m;
            int m2;
            int j;
            int begin = 1 << i - 1;
            int end = (1 << i) - 1;
            boolean notLastStep = i + 1 != w;
            int start = 0;
            if (notLastStep) {
                j = begin;
                while (j <= end) {
                    NennerLambda[start] = (GF2nElement)doubleP.getX().add(((PointGF2n)P[start]).getX());
                    ++start;
                    ++j;
                }
                NennerLambda[start] = (GF2nElement)doubleP.getX();
                NennerLambdaInvers[0] = (GF2nElement)NennerLambda[0].clone();
                m2 = 1;
                while (m2 <= begin) {
                    NennerLambdaInvers[m2] = (GF2nElement)NennerLambdaInvers[m2 - 1].multiply(NennerLambda[m2]);
                    ++m2;
                }
                invers = (GF2nElement)NennerLambdaInvers[begin].invert();
                m = begin;
                while (m >= 1) {
                    NennerLambdaInvers[m] = (GF2nElement)NennerLambdaInvers[m - 1].multiply(invers);
                    invers = (GF2nElement)invers.multiply(NennerLambda[m]);
                    --m;
                }
                NennerLambdaInvers[0] = invers;
            } else {
                j = begin;
                while (j <= end) {
                    NennerLambda[start] = (GF2nElement)doubleP.getX().add(((PointGF2n)P[start]).getX());
                    ++start;
                    ++j;
                }
                NennerLambdaInvers[0] = (GF2nElement)NennerLambda[0].clone();
                m2 = 1;
                while (m2 < begin) {
                    NennerLambdaInvers[m2] = (GF2nElement)NennerLambdaInvers[m2 - 1].multiply(NennerLambda[m2]);
                    ++m2;
                }
                invers = (GF2nElement)NennerLambdaInvers[begin - 1].invert();
                m = begin - 1;
                while (m >= 1) {
                    NennerLambdaInvers[m] = (GF2nElement)NennerLambdaInvers[m - 1].multiply(invers);
                    invers = (GF2nElement)invers.multiply(NennerLambda[m]);
                    --m;
                }
                NennerLambdaInvers[0] = invers;
            }
            GF2nElement lambda = null;
            GF2nElement tmp = null;
            start = 0;
            int j2 = begin;
            while (j2 <= end) {
                GF2nElement startX = (GF2nElement)((PointGF2n)P[start]).getX();
                GF2nElement startY = (GF2nElement)((PointGF2n)P[start]).getY();
                lambda = (GF2nElement)doubleP.getY().add(startY);
                lambda = (GF2nElement)NennerLambdaInvers[start].multiply(lambda);
                tmp = lambda.square();
                tmp = (GF2nElement)lambda.add(tmp);
                tmp = (GF2nElement)tmp.add(doubleP.getX());
                tmp = (GF2nElement)tmp.add(startX);
                GF2nElement x = (GF2nElement)tmp.add(((EllipticCurveGF2n)p.getE()).getA());
                tmp = (GF2nElement)startX.add(x);
                tmp = (GF2nElement)lambda.multiply(tmp);
                tmp = (GF2nElement)tmp.add(x);
                y = (GF2nElement)tmp.add(startY);
                P[j2] = new PointGF2n(x, y, (EllipticCurveGF2n)p.getE());
                ++start;
                ++j2;
            }
            if (notLastStep) {
                lambda = (GF2nElement)doubleP.getY().multiply(NennerLambdaInvers[start]);
                lambda = (GF2nElement)lambda.add(doubleP.getX());
                tmp = lambda.square();
                tmp = (GF2nElement)tmp.add(lambda);
                GF2nElement x = (GF2nElement)tmp.add(((EllipticCurveGF2n)p.getE()).getA());
                GF2nElement element = (GF2nElement)doubleP.getX();
                GF2nField field = element.getField();
                tmp = ScalarMult.createGF2nOneElement(field);
                tmp = (GF2nElement)tmp.add(lambda);
                tmp = (GF2nElement)tmp.multiply(x);
                GF2nElement mX = (GF2nElement)doubleP.getX();
                y = (GF2nElement)tmp.add(mX.square());
                doubleP = new PointGF2n(x, y, (EllipticCurveGF2n)doubleP.getE());
            }
            ++i;
        }
        return P;
    }

    public static PointGFP[] precomputationDOS(PointGFP point, int k) {
        int i;
        if (k < 2) {
            throw new RuntimeException("window size must be at least 2.");
        }
        FlexiBigInt[] di = new FlexiBigInt[k];
        FlexiBigInt[] ei = new FlexiBigInt[k];
        FlexiBigInt[] fi = new FlexiBigInt[k];
        FlexiBigInt[] li = new FlexiBigInt[k];
        FlexiBigInt A = null;
        FlexiBigInt B = null;
        FlexiBigInt C = null;
        FlexiBigInt D = null;
        FlexiBigInt E = null;
        PointGFP[] points = new PointGFP[k];
        PointGFP p = (PointGFP)point.clone();
        p = (PointGFP)p.getAffin();
        FlexiBigInt y = p.getY().toFlexiBigInt();
        FlexiBigInt x = p.getX().toFlexiBigInt();
        EllipticCurveGFP el = (EllipticCurveGFP)p.getE();
        FlexiBigInt prime = el.getQ();
        FlexiBigInt a = el.getA().toFlexiBigInt();
        di[0] = y.multiply(new FlexiBigInt(Integer.toString(2))).mod(prime);
        C = di[0].multiply(di[0]).mod(prime);
        A = x.multiply(x).mod(prime).multiply(new FlexiBigInt(Integer.toString(3))).add(a).mod(prime);
        B = C.multiply(x).multiply(new FlexiBigInt(Integer.toString(3))).mod(prime);
        di[1] = A.multiply(A).mod(prime).subtract(B).mod(prime);
        if (k >= 3) {
            E = di[1].multiply(di[1]).mod(prime);
            B = E.multiply(B).mod(prime);
            C = C.multiply(C).mod(prime);
            D = E.multiply(di[1]).mod(prime);
            A = di[1].negate().multiply(A).subtract(C).mod(prime);
            di[2] = A.multiply(A).mod(prime).subtract(B).subtract(D.add(D)).mod(prime);
            if (k >= 4) {
                E = di[2].multiply(di[2]).mod(prime);
                B = E.multiply(B.add(D.multiply(new FlexiBigInt(Integer.toString(3))))).mod(prime);
                C = D.multiply(A.add(A).add(C)).mod(prime);
                D = E.multiply(di[2]).mod(prime);
                A = di[2].negate().multiply(A).subtract(C).mod(prime);
                di[3] = A.multiply(A).mod(prime).subtract(D).subtract(B).mod(prime);
                if (k >= 5) {
                    i = 4;
                    while (i <= k - 1) {
                        E = di[i - 1].multiply(di[i - 1]).mod(prime);
                        B = E.multiply(B).mod(prime);
                        C = D.multiply(C).mod(prime);
                        D = E.multiply(di[i - 1]).mod(prime);
                        A = di[i - 1].negate().multiply(A).subtract(C).mod(prime);
                        di[i] = A.multiply(A).mod(prime).subtract(D).subtract(B).mod(prime);
                        ++i;
                    }
                }
            }
        }
        ei[0] = di[0];
        i = 1;
        while (i <= k - 1) {
            ei[i] = ei[i - 1].multiply(di[i]).mod(prime);
            ++i;
        }
        FlexiBigInt T1 = ei[k - 1].modInverse(prime);
        int i2 = k - 1;
        while (i2 >= 1) {
            FlexiBigInt T2 = di[i2];
            fi[i2] = ei[i2 - 1].multiply(T1).mod(prime);
            T1 = T1.multiply(T2).mod(prime);
            --i2;
        }
        fi[0] = T1;
        li[0] = fi[0];
        int i3 = 1;
        while (i3 <= k - 1) {
            li[i3] = ei[i3 - 1].multiply(ei[i3 - 1]).mod(prime).multiply(fi[i3]).mod(prime);
            ++i3;
        }
        FlexiBigInt T = x.multiply(x).mod(prime).multiply(new FlexiBigInt(Integer.toString(3))).add(a).multiply(li[0]).mod(prime);
        FlexiBigInt x2 = T.multiply(T).mod(prime).subtract(x.add(x)).mod(prime);
        FlexiBigInt y2 = T.multiply(x.subtract(x2)).subtract(y).mod(prime);
        T = y2.subtract(y).multiply(li[1]).mod(prime);
        FlexiBigInt x3 = T.multiply(T).mod(prime).subtract(x2).subtract(x).mod(prime);
        FlexiBigInt y3 = T.multiply(x2.subtract(x3)).subtract(y2).mod(prime);
        points[0] = p;
        GFPElement gfpx3 = new GFPElement(x3, point.getE().getQ());
        GFPElement gfpy3 = new GFPElement(y3, point.getE().getQ());
        points[1] = new PointGFP(gfpx3, gfpy3, el);
        int i4 = 2;
        while (i4 <= k - 1) {
            T = points[i4 - 1].getYAffin().toFlexiBigInt().subtract(y2).multiply(li[i4]).mod(prime);
            FlexiBigInt xi = T.multiply(T).mod(prime).subtract(x2).subtract(points[i4 - 1].getXAffin().toFlexiBigInt()).mod(prime);
            FlexiBigInt yi = T.multiply(x2.subtract(xi)).subtract(y2).mod(prime);
            GFPElement gfpxi = new GFPElement(xi, point.getE().getQ());
            GFPElement gfpyi = new GFPElement(yi, point.getE().getQ());
            points[i4] = new PointGFP(gfpxi, gfpyi, el);
            ++i4;
        }
        return points;
    }

    public static Point[][] pre_simultaneous2w(Point P, Point Q, int w) {
        int k = 1 << w - 1;
        int l = k << 1;
        Point[][] r = ScalarMult.createPointMatrix(P, Q, l, l);
        r[0][0] = ScalarMult.createZeroPoint(P, Q, P.getE());
        int i = 0;
        int j = i << 1;
        while (i < k) {
            int m = 0;
            int n = m << 1;
            while (m < k) {
                r[j][n] = r[i][m].multiplyBy2();
                r[j][n + 1] = r[j][n].add(Q);
                n = ++m << 1;
            }
            int o = j + 1;
            int m2 = 0;
            while (m2 < l) {
                r[o][m2] = r[o - 1][m2].add(P);
                ++m2;
            }
            j = ++i << 1;
        }
        return r;
    }

    public static Point[][] pre_simultaneousSlidingWindow(Point P, Point Q, int w) {
        int l = 1 << w;
        Point[][] r = new Point[l][l];
        Point p2 = P.multiplyBy2();
        Point q2 = Q.multiplyBy2();
        r[0][0] = ScalarMult.createZeroPoint(P, Q, P.getE());
        r[1][0] = P;
        r[0][1] = Q;
        int i = 3;
        while (i < l) {
            r[0][i] = r[0][i - 2].add(q2);
            r[i][0] = r[i - 2][0].add(p2);
            i += 2;
        }
        int i2 = 1;
        while (i2 < l) {
            int j = 1;
            while (j < l) {
                r[i2][j] = r[i2][j - 1].add(Q);
                ++j;
            }
            i2 += 2;
        }
        int i3 = 2;
        while (i3 < l) {
            int j = 1;
            while (j < l) {
                r[i3][j] = r[i3 - 1][j].add(P);
                j += 2;
            }
            i3 += 2;
        }
        return r;
    }

    public static Point[][] pre_shamir(Point Q0, Point Q1, int w) {
        int l = (1 << w) + 1;
        Point[][] P = new Point[l][l];
        Point p2 = Q0.multiplyBy2();
        Point q12 = Q1.multiplyBy2();
        P[0][0] = ScalarMult.createZeroPoint(Q0, Q1, Q0.getE());
        P[1][0] = Q0;
        P[2][0] = Q0.negate();
        P[0][1] = Q1;
        P[0][2] = Q1.negate();
        int i = 3;
        while (i < l) {
            if ((i & 1) == 1) {
                P[0][i] = P[0][i - 2].add(q12);
                P[i][0] = P[i - 2][0].add(p2);
            } else {
                P[0][i] = P[0][i - 2].subtract(q12);
                P[i][0] = P[i - 2][0].subtract(p2);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < l) {
            int j = 0;
            while (j < l) {
                if (i2 != 0 && j != 0) {
                    P[i2][j] = P[i2][0];
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < l) {
            int j = 0;
            while (j < l) {
                if (i3 != 0 && j != 0) {
                    P[i3][j] = P[i3][j].add(P[0][j]);
                }
                ++j;
            }
            ++i3;
        }
        return P;
    }

    public static Point[][] pre_shamirGFP(PointGFP q0, PointGFP q1, int w) {
        FlexiBigInt t;
        int l = (1 << w) + 1;
        Point[][] P = new PointGFP[l][l];
        PointGFP Q0 = (PointGFP)q0.getAffin();
        PointGFP Q1 = (PointGFP)q1.getAffin();
        P[0][0] = new PointGFP((EllipticCurveGFP)Q0.getE());
        Q0.getAffin();
        Q1.getAffin();
        EllipticCurveGFP el = (EllipticCurveGFP)Q1.getE();
        FlexiBigInt prime = el.getQ();
        PointGFP[] temp = ScalarMult.precomputationDOS(Q1, 1 << w - 1);
        int i = 0;
        while (i < temp.length) {
            P[0][i + i + 1] = temp[i];
            P[0][i + i + 2] = (PointGFP)temp[i].negate();
            ++i;
        }
        temp = ScalarMult.precomputationDOS(Q0, 1 << w - 1);
        int i2 = 0;
        while (i2 < temp.length) {
            P[i2 + i2 + 1][0] = temp[i2];
            P[i2 + i2 + 2][0] = (PointGFP)temp[i2].negate();
            ++i2;
        }
        int k = (l - 1) * (l - 1);
        FlexiBigInt[] delta = new FlexiBigInt[k];
        int z = 0;
        int i3 = 1;
        while (i3 < l) {
            int j = 1;
            while (j < l) {
                delta[z] = P[0][i3].getX().toFlexiBigInt().subtract(P[j][0].getX().toFlexiBigInt()).mod(prime);
                ++z;
                ++j;
            }
            ++i3;
        }
        FlexiBigInt[] d = new FlexiBigInt[k];
        d[0] = delta[0];
        int i4 = 1;
        while (i4 < d.length) {
            d[i4] = d[i4 - 1].multiply(delta[i4]).mod(prime);
            ++i4;
        }
        FlexiBigInt[] b = new FlexiBigInt[k];
        b[k - 1] = d[k - 1].modInverse(prime);
        FlexiBigInt[] inv = new FlexiBigInt[k];
        int i5 = k - 1;
        while (i5 > 0) {
            inv[i5] = d[i5 - 1].multiply(b[i5]).mod(prime);
            b[i5 - 1] = b[i5].multiply(delta[i5]).mod(prime);
            --i5;
        }
        inv[0] = b[0];
        FlexiBigInt[][] lambda = new FlexiBigInt[l - 1][l - 1];
        z = 0;
        int i6 = 0;
        while (i6 < lambda[0].length) {
            int j = 0;
            while (j < lambda[0].length) {
                lambda[j][i6] = inv[z];
                ++z;
                ++j;
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < lambda[0].length) {
            int j = 0;
            while (j < lambda[0].length) {
                t = ((PointGFP)P[0][i7 + 1]).getY().toFlexiBigInt().subtract(((PointGFP)P[j + 1][0]).getY().toFlexiBigInt()).mod(prime);
                lambda[j][i7] = lambda[j][i7].multiply(t).mod(prime);
                ++j;
            }
            ++i7;
        }
        int i8 = 0;
        while (i8 < lambda[0].length) {
            int j = 0;
            while (j < lambda[0].length) {
                t = lambda[i8][j].multiply(lambda[i8][j]).mod(prime);
                t = t.subtract(((PointGFP)P[i8 + 1][0]).getX().toFlexiBigInt()).mod(prime);
                t = t.subtract(((PointGFP)P[0][j + 1]).getX().toFlexiBigInt()).mod(prime);
                GFPElement x = new GFPElement(t, prime);
                t = ((PointGFP)P[i8 + 1][0]).getX().toFlexiBigInt().subtract(t).mod(prime);
                t = t.multiply(lambda[i8][j]).mod(prime);
                t = t.subtract(((PointGFP)P[i8 + 1][0]).getY().toFlexiBigInt()).mod(prime);
                GFPElement y = new GFPElement(t, prime);
                P[i8 + 1][j + 1] = new PointGFP(x, y, el);
                ++j;
            }
            ++i8;
        }
        return P;
    }

    public static Point[][][] pre_shamir(Point Q0, Point Q1, Point Q2, int w) {
        int l = (1 << w) + 1;
        Point[][][] P = new Point[l][l][l];
        Point p2 = Q0.multiplyBy2();
        Point q12 = Q1.multiplyBy2();
        Point q22 = Q2.multiplyBy2();
        P[0][0][0] = ScalarMult.createZeroPoint(Q0, Q1, Q0.getE());
        P[1][0][0] = Q0;
        P[2][0][0] = Q0.negate();
        P[0][1][0] = Q1;
        P[0][2][0] = Q1.negate();
        P[0][0][1] = Q2;
        P[0][0][2] = Q2.negate();
        int i = 3;
        while (i < l) {
            if ((i & 1) == 1) {
                P[0][0][i] = P[0][0][i - 2].add(q22);
                P[0][i][0] = P[0][i - 2][0].add(q12);
                P[i][0][0] = P[i - 2][0][0].add(p2);
            } else {
                P[0][0][i] = P[0][0][i - 2].subtract(q22);
                P[0][i][0] = P[0][i - 2][0].subtract(q12);
                P[i][0][0] = P[i - 2][0][0].subtract(p2);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < l) {
            int j = 0;
            while (j < l) {
                int k = 0;
                while (k < l) {
                    if (!(i2 == 0 && j == 0 || j == 0 && k == 0 || i2 == 0 && k == 0)) {
                        P[i2][j][k] = P[i2][0][0];
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < l) {
            int j = 0;
            while (j < l) {
                int k = 0;
                while (k < l) {
                    if (!(i3 == 0 && j == 0 || j == 0 && k == 0 || i3 == 0 && k == 0)) {
                        P[i3][j][k] = P[i3][j][k].add(P[0][j][0]);
                        P[i3][j][k] = P[i3][j][k].add(P[0][0][k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        return P;
    }

    public static Point[][][][] pre_shamir(Point Q0, Point Q1, Point Q2, Point Q3, int w) {
        int l = (1 << w) + 1;
        Point[][][][] P = new Point[l][l][l][l];
        Point p2 = Q0.multiplyBy2();
        Point q12 = Q1.multiplyBy2();
        Point q22 = Q2.multiplyBy2();
        Point q32 = Q3.multiplyBy2();
        P[0][0][0][0] = ScalarMult.createZeroPoint(Q0, Q1, Q0.getE());
        P[1][0][0][0] = Q0;
        P[2][0][0][0] = Q0.negate();
        P[0][1][0][0] = Q1;
        P[0][2][0][0] = Q1.negate();
        P[0][0][1][0] = Q2;
        P[0][0][2][0] = Q2.negate();
        P[0][0][0][1] = Q3;
        P[0][0][0][2] = Q3.negate();
        int i = 3;
        while (i < l) {
            if ((i & 1) == 1) {
                P[0][0][0][i] = P[0][0][0][i - 2].add(q32);
                P[0][0][i][0] = P[0][0][i - 2][0].add(q22);
                P[0][i][0][0] = P[0][i - 2][0][0].add(q12);
                P[i][0][0][0] = P[i - 2][0][0][0].add(p2);
            } else {
                P[0][0][0][i] = P[0][0][0][i - 2].subtract(q32);
                P[0][0][i][0] = P[0][0][i - 2][0].subtract(q22);
                P[0][i][0][0] = P[0][i - 2][0][0].subtract(q12);
                P[i][0][0][0] = P[i - 2][0][0][0].subtract(p2);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < l) {
            int j = 0;
            while (j < l) {
                int k = 0;
                while (k < l) {
                    int m = 0;
                    while (m < l) {
                        if (!(i2 == 0 && j == 0 && k == 0 || i2 == 0 && j == 0 && m == 0 || i2 == 0 && k == 0 && m == 0 || j == 0 && k == 0 && m == 0)) {
                            P[i2][j][k][m] = P[i2][0][0][0];
                        }
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < l) {
            int j = 0;
            while (j < l) {
                int k = 0;
                while (k < l) {
                    int m = 0;
                    while (m < l) {
                        if (!(i3 == 0 && j == 0 && k == 0 || i3 == 0 && j == 0 && m == 0 || i3 == 0 && k == 0 && m == 0 || j == 0 && k == 0 && m == 0)) {
                            P[i3][j][k][m] = P[i3][j][k][m].add(P[0][j][0][0]);
                            P[i3][j][k][m] = P[i3][j][k][m].add(P[0][0][k][0]);
                            P[i3][j][k][m] = P[i3][j][k][m].add(P[0][0][0][m]);
                        }
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        return P;
    }

    public static Point[] pre_limlee(Point p, FlexiBigInt m, int n) {
        int length = m.bitLength();
        length = length % n == 0 ? length : (length / n + 1) * n;
        int l = length / n;
        Point[] odd = new Point[n];
        odd[0] = p;
        if (n > 1) {
            Point R = (Point)p.clone();
            int j = 1;
            while (j < odd.length) {
                int i = 0;
                while (i < l) {
                    R = R.multiplyBy2();
                    ++i;
                }
                odd[j] = R;
                ++j;
            }
        }
        return odd;
    }

    public static Point[] pre_limleeAffine(Point p, FlexiBigInt m, int n) {
        int length = m.bitLength();
        length = length % n == 0 ? length : (length / n + 1) * n;
        int l = length / n;
        Point[] odd = new Point[n];
        odd[0] = p;
        if (n > 1) {
            Point R = (Point)p.clone();
            int j = 1;
            while (j < odd.length) {
                int i = 0;
                while (i < l) {
                    R = R.multiplyBy2();
                    ++i;
                }
                odd[j] = R.getAffin();
                ++j;
            }
        }
        return odd;
    }

    public static FlexiBigInt[] split_limlee(FlexiBigInt m, int n) {
        int length = m.bitLength();
        length = length % n == 0 ? length : (length / n + 1) * n;
        int l = length / n;
        FlexiBigInt[] P = new FlexiBigInt[n];
        FlexiBigInt b = m.abs();
        int i = 0;
        while (i < n) {
            FlexiBigInt l1 = b.shiftRight(l).shiftLeft(l);
            P[i] = b.subtract(l1);
            b = l1.shiftRight(l);
            ++i;
        }
        if (m.signum() == -1) {
            int i2 = 0;
            while (i2 < P.length) {
                if (!P[i2].equals(FlexiBigInt.ZERO)) {
                    P[i2] = P[i2].negate();
                }
                ++i2;
            }
        }
        return P;
    }

    public static int[] determineNaf(FlexiBigInt e, int w, int b) {
        int power2wi = 1 << w;
        int[] N = new int[b + 1];
        FlexiBigInt c = e.abs();
        int s = e.signum();
        int j = 0;
        while (c.compareTo(FlexiBigInt.ZERO) > 0) {
            int u;
            if (c.testBit(0)) {
                u = c.intValue() & (power2wi << 1) - 1;
                if ((u & power2wi) != 0) {
                    u -= power2wi << 1;
                }
                c = c.subtract(FlexiBigInt.valueOf(u));
            } else {
                u = 0;
            }
            N[j++] = s > 0 ? u : -u;
            c = c.shiftRight(1);
        }
        while (j <= b) {
            N[j++] = 0;
        }
        return N;
    }

    public static int[] determineNaf(FlexiBigInt e, int w) {
        return ScalarMult.determineNaf(e, w, e.bitLength());
    }

    private static void determineNaf(int[] N, FlexiBigInt e, int w) {
        int power2wi = 1 << w;
        FlexiBigInt c = e.abs();
        int s = e.signum();
        int j = 0;
        while (c.compareTo(FlexiBigInt.ZERO) > 0) {
            int u;
            if (c.testBit(0)) {
                u = c.intValue() & (power2wi << 1) - 1;
                if ((u & power2wi) != 0) {
                    u -= power2wi << 1;
                }
                c = c.subtract(FlexiBigInt.valueOf(u));
            } else {
                u = 0;
            }
            N[j++] = s > 0 ? u : -u;
            c = c.shiftRight(1);
        }
        while (j < N.length) {
            N[j++] = 0;
        }
    }

    public static int[] determineRtlFSSW(FlexiBigInt e, int w) {
        int j;
        int s;
        FlexiBigInt m = e.abs();
        int b = m.bitLength();
        int[] fssw = new int[b];
        int i = m.bitLength() - 1;
        int t = (i + 1) % w;
        if (t != 0) {
            s = 0;
            j = 0;
            while (j < t) {
                s <<= 1;
                if (m.testBit(i - j)) {
                    ++s;
                }
                ++j;
            }
            fssw[i - t + 1] = s;
        }
        i -= t;
        while (i >= 0) {
            s = 0;
            j = i;
            while (j > i - w) {
                s <<= 1;
                if (m.testBit(j)) {
                    ++s;
                }
                --j;
            }
            if (s > 0) {
                fssw[i - w + 1] = s;
            }
            i -= w;
        }
        if (e.signum() == -1) {
            int l = 0;
            while (l < fssw.length) {
                if (fssw[l] != 0) {
                    fssw[l] = -fssw[l];
                }
                ++l;
            }
        }
        return fssw;
    }

    public static int[] determineLtrFSSW(FlexiBigInt e, int w) {
        int j;
        int s;
        FlexiBigInt m = e.abs();
        int b = m.bitLength();
        int[] fssw = new int[b];
        int i = m.bitLength() - 1;
        int t = (i + 1) % w;
        while (i + 1 >= w) {
            s = 0;
            j = i;
            while (j > i - w) {
                s <<= 1;
                if (m.testBit(j)) {
                    ++s;
                }
                --j;
            }
            if (s > 0) {
                fssw[i - w + 1] = s;
            }
            i -= w;
        }
        if (t != 0) {
            s = 0;
            j = 0;
            while (j < t) {
                s <<= 1;
                if (m.testBit(i - j)) {
                    ++s;
                }
                ++j;
            }
            fssw[0] = s;
        }
        if (e.signum() == -1) {
            int l = 0;
            while (l < fssw.length) {
                if (fssw[l] != 0) {
                    fssw[l] = -fssw[l];
                }
                ++l;
            }
        }
        return fssw;
    }

    public static int[] determineSW(FlexiBigInt e, int w) {
        FlexiBigInt m = e.abs();
        int b = m.bitLength();
        int[] sw = new int[b];
        int i = m.bitLength() - 1;
        while (i >= 0) {
            if (!m.testBit(i)) {
                --i;
                continue;
            }
            int k = i - w > -1 ? i - w : -1;
            int j = k + 1;
            while (!m.testBit(j)) {
                ++j;
            }
            int s = 0;
            int p = i;
            while (p >= j) {
                s <<= 1;
                if (m.testBit(p)) {
                    ++s;
                }
                --p;
            }
            sw[j] = s;
            i -= i - j + 1;
        }
        if (e.signum() == -1) {
            int l = 0;
            while (l < sw.length) {
                if (sw[l] != 0) {
                    sw[l] = -sw[l];
                }
                ++l;
            }
        }
        return sw;
    }

    public static int[] determineRtlSFW(FlexiBigInt e, int m) {
        if ((m & 1) == 0) {
            throw new RuntimeException("Parameter m must be odd");
        }
        FlexiBigInt b1 = e.abs();
        int b = b1.bitLength();
        int[] sfw = new int[b + 1];
        int i = 0;
        FlexiBigInt bm = new FlexiBigInt(Integer.toString(m));
        int wm = bm.bitLength();
        int Wm = wm + 1;
        int D = b1.mod(new FlexiBigInt(Integer.toString(1 << Wm))).intValue();
        while (D != 0 || i + wm < b) {
            int x = D % (1 << Wm);
            int d = (x & 1) == 0 ? 0 : (0 < x && x <= m ? x : (m < x && x < (1 << Wm) - m ? x - (1 << wm) : x - (1 << Wm)));
            sfw[i] = d;
            int bit = b1.testBit(++i + wm) ? 1 : 0;
            D = (bit << wm) + (D - d) / 2;
        }
        if (e.signum() == -1) {
            int j = 0;
            while (j < sfw.length) {
                if (sfw[j] != 0) {
                    sfw[j] = -sfw[j];
                }
                ++j;
            }
        }
        return sfw;
    }

    public static int[] determineLtrSFW(FlexiBigInt e, int m) {
        if ((m & 1) == 0) {
            throw new RuntimeException("Parameter m must be odd");
        }
        FlexiBigInt b1 = e.abs();
        int b = b1.bitLength();
        int[] sfw = new int[b + 1];
        int[] b2 = new int[b + 3];
        int i = 0;
        while (i < b) {
            b2[i] = b1.testBit(i) ? 1 : 0;
            ++i;
        }
        FlexiBigInt bm = new FlexiBigInt(Integer.toString(m));
        int wm = bm.bitLength();
        int Wm = wm + 1;
        int i2 = b + 2;
        int l = 0;
        while (i2 >= 0) {
            if (i2 >= 1 && b2[i2] == b2[i2 - 1] || i2 == 0 && b2[0] == 0) {
                --i2;
                continue;
            }
            int W = Wm;
            int[] temp = new int[W];
            if (i2 - W + 1 >= 0) {
                System.arraycopy(b2, i2 - W + 1, temp, 0, W);
            } else {
                System.arraycopy(b2, 0, temp, W - i2 - 1, i2 + 1);
            }
            temp[W - 1] = -temp[W - 1];
            int d = 0;
            int t = 1;
            int z = 0;
            while (z < temp.length) {
                if (temp[z] != 0) {
                    d = temp[z] * t + d;
                    t <<= 1;
                } else {
                    t <<= 1;
                }
                ++z;
            }
            if (i2 >= W) {
                d += b2[i2 - W];
            }
            if (d & true && (d > m || -d > m)) {
                W = wm;
                temp = new int[W];
                if (i2 - W + 1 >= 0) {
                    System.arraycopy(b2, i2 - W + 1, temp, 0, W);
                } else {
                    System.arraycopy(b2, 0, temp, W - i2 - 1, i2 + 1);
                }
                temp[W - 1] = -temp[W - 1];
                d = 0;
                t = 1;
                int z2 = 0;
                while (z2 < temp.length) {
                    if (temp[z2] != 0) {
                        d = temp[z2] * t + d;
                        t <<= 1;
                    } else {
                        t <<= 1;
                    }
                    ++z2;
                }
                if (i2 >= W) {
                    d += b2[i2 - W];
                }
            }
            int nexti = i2 - W;
            i2 = nexti + 1;
            while ((d & 1) == 0) {
                ++i2;
                d >>= 1;
            }
            if (i2 >= 0) {
                sfw[i2] = d;
            }
            if (i2 > l) {
                l = i2;
            }
            i2 = nexti;
        }
        if (e.signum() == -1) {
            int j = 0;
            while (j < sfw.length) {
                if (sfw[j] != 0) {
                    sfw[j] = -sfw[j];
                }
                ++j;
            }
        }
        return sfw;
    }

    private static int[][] getMofTable(int w) {
        int[][] table = new int[2][1 << w];
        int h = 1 << w - 1;
        int cd = (1 << w) - 1;
        int d = h;
        while (d < 3 * h) {
            int c = (d & cd) - (d >> 1);
            int z = d - (1 << w - 1);
            table[1][z] = 0;
            while ((c & 1) == 0) {
                int[] nArray = table[1];
                int n = z;
                nArray[n] = nArray[n] + 1;
                c >>= 1;
            }
            table[0][z] = c;
            ++d;
        }
        return table;
    }

    public static int[] determineMof(FlexiBigInt d, int w) {
        int n = d.bitLength() + 1;
        int[] mof = new int[n];
        int[][] table = ScalarMult.getMofTable(w);
        int i = n;
        while (i > 0) {
            if (d.testBit(i) != d.testBit(i - 1)) {
                FlexiBigInt indexl = d.shiftRight(i - w);
                FlexiBigInt indexr = new FlexiBigInt(Integer.toString((1 << w + 1) - 1));
                int index = indexl.and(indexr).intValue() - (1 << w - 1);
                mof[i - w + 1 + table[1][index]] = table[0][index];
                i -= w;
                continue;
            }
            --i;
        }
        if (i == 0 && d.testBit(0)) {
            mof[0] = -1;
        }
        return mof;
    }

    public static int[] determineMof(FlexiBigInt d) {
        FlexiBigInt e = d.abs();
        int n = e.bitLength();
        int[] mof = new int[n + 1];
        if (e.equals(FlexiBigInt.ZERO)) {
            return mof;
        }
        if (e.testBit(n - 1)) {
            mof[n] = 1;
        }
        int i = n - 1;
        while (i > 0) {
            if (e.testBit(i) && !e.testBit(i - 1)) {
                mof[i] = -1;
            }
            if (!e.testBit(i) && e.testBit(i - 1)) {
                mof[i] = 1;
            }
            --i;
        }
        if (e.testBit(0)) {
            mof[0] = -1;
        }
        if (d.signum() == -1) {
            int l = 0;
            while (l < mof.length) {
                if (mof[l] != 0) {
                    mof[l] = -mof[l];
                }
                ++l;
            }
        }
        return mof;
    }

    /*
     * Unable to fully structure code
     */
    public static int[][] determineJsf(FlexiBigInt[] d) {
        D = new FlexiBigInt[d.length];
        i = 0;
        while (i < D.length) {
            D[i] = d[i].abs();
            ++i;
        }
        h = D.length;
        a = 0;
        i = 0;
        while (i < h) {
            a = a < D[i].bitLength() ? D[i].bitLength() : a;
            ++i;
        }
        T = new int[h][a + 1];
        i = 0;
        while (i < h) {
            j = 0;
            while (j < D[i].bitLength()) {
                if (D[i].testBit(j)) {
                    T[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        y = 0;
        badrows = new int[h];
        i = 0;
        while (i < h) {
            badrows[i] = 1;
            ++i;
        }
        zerocolumns = new int[a + 1];
        while (y <= a) {
            flag = true;
            i = 0;
            while (i < h) {
                if (badrows[i] != 0 && T[i][y] != 0) {
                    badrows[i] = 0;
                    flag = false;
                }
                ++i;
            }
            if (flag) {
                zerocolumns[y] = 1;
                i = 0;
                while (i < h) {
                    badrows[i] = 1;
                    ++i;
                }
                i = 0;
                while (i < h) {
                    if (T[i][y] == 1) {
                        T[i][y] = 0;
                        j = y - 1;
                        while (T[i][j] == 0) {
                            --j;
                        }
                        if (T[i][j] == 1) {
                            m = y + 1;
                            while (T[i][m] == 1) {
                                T[i][m] = 0;
                                ++m;
                            }
                            v0 = T[i];
                            v1 = m;
                            v0[v1] = v0[v1] + 1;
                            m = y - 1;
                            while (T[i][m] == 0) {
                                T[i][m] = -1;
                                --m;
                            }
                            T[i][m] = -1;
                        } else if (T[i][j] == -1) {
                            m = y - 1;
                            while (T[i][m] == 0) {
                                T[i][m] = 1;
                                --m;
                            }
                            T[i][m] = 1;
                        }
                    } else if (T[i][y] == -1) {
                        T[i][y] = 0;
                        j = y - 1;
                        while (T[i][j] == 0) {
                            --j;
                        }
                        if (T[i][j] == 1) {
                            m = y - 1;
                            while (T[i][m] == 0) {
                                T[i][m] = -1;
                                --m;
                            }
                            T[i][m] = -1;
                        } else if (T[i][j] == -1) {
                            m = y + 1;
                            while (T[i][m] == -1) {
                                T[i][m] = 0;
                                ++m;
                            }
                            v2 = T[i];
                            v3 = m;
                            v2[v3] = v2[v3] - 1;
                            m = y - 1;
                            while (T[i][m] == 0) {
                                T[i][m] = 1;
                                --m;
                            }
                            T[i][m] = 1;
                        }
                    }
                    ++i;
                }
            }
            ++y;
        }
        i = 0;
        while (i < h) {
            j = 0;
            ** GOTO lbl150
            {
                ++j;
                do {
                    if (j <= a && T[i][j] == 0) continue block18;
                    if (j < a && T[i][j] * T[i][j + 1] == -1) {
                        T[i][j] = -T[i][j];
                        T[i][j + 1] = 0;
                        j += 2;
                        continue;
                    }
                    if (j < a && T[i][j] == T[i][j + 1]) {
                        z = j + 1;
                        while (z < a && T[i][j] == T[i][z + 1]) {
                            ++z;
                        }
                        if (z < a && T[i][z + 1] == 0 && zerocolumns[z + 1] == 0) {
                            T[i][z + 1] = T[i][j];
                            k = j + 1;
                            while (k <= z) {
                                T[i][k] = 0;
                                ++k;
                            }
                            T[i][j] = -T[i][j];
                        } else if (z < a && T[i][z + 1] == -T[i][j]) {
                            k = j + 1;
                            while (k <= z + 1) {
                                T[i][k] = 0;
                                ++k;
                            }
                            T[i][j] = -T[i][j];
                        }
                        j = z + 1;
                        continue;
                    }
                    j += 2;
lbl150:
                    // 4 sources

                } while (j < a);
            }
            ++i;
        }
        i = 0;
        while (i < D.length) {
            if (d[i].signum() == -1) {
                j = 0;
                while (j < T[i].length) {
                    if (T[i][j] != 0) {
                        T[i][j] = -T[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return T;
    }

    private static int[] calculateZ(int[] m0, int[] m1, int c) {
        int k = m0.length > m1.length ? m0.length : m1.length;
        int[] z = new int[k];
        int f0 = -1;
        int j = k - 1;
        while (j >= 0) {
            if (m0[j] != 0) {
                f0 = j;
            }
            --j;
        }
        int f1 = -1;
        int j2 = k - 1;
        while (j2 >= 0) {
            if (m1[j2] != 0) {
                f1 = j2;
            }
            --j2;
        }
        int r = 0;
        int j3 = k - 1;
        while (j3 >= 0) {
            if (j3 == f0 || j3 == f1 || r == 2) {
                z[j3] = 0;
                r = 0;
            } else {
                z[j3] = 1;
                ++r;
            }
            if (c == 0 && j3 == k - 1 && z[k - 1] == 1) {
                r = 2;
            }
            --j3;
        }
        return z;
    }

    private static void convert(int[] m0, int[] m1, int[] z) {
        int s;
        int k = m0.length > m1.length ? m0.length : m1.length;
        int j = k - 1;
        while (j >= 0) {
            if (z[j] == 1 && m0[j] != 0) {
                int t;
                s = j - 1;
                while (m0[s] == 0) {
                    --s;
                }
                if (m0[j] == -m0[s]) {
                    t = j - 1;
                    while (t >= s) {
                        m0[t] = m0[j];
                        --t;
                    }
                    m0[j] = 0;
                } else if (m0[j] == m0[s]) {
                    t = j - 2;
                    while (t >= s) {
                        m0[t] = -m0[j];
                        --t;
                    }
                    m0[j - 1] = 3 * m0[j];
                    m0[j] = 0;
                }
            }
            --j;
        }
        int j2 = k - 1;
        while (j2 >= 0) {
            if (z[j2] == 1 && m1[j2] != 0) {
                int t;
                s = j2 - 1;
                while (m1[s] == 0) {
                    --s;
                }
                if (m1[j2] == -m1[s]) {
                    t = j2 - 1;
                    while (t >= s) {
                        m1[t] = m1[j2];
                        --t;
                    }
                    m1[j2] = 0;
                } else if (m1[j2] == m1[s]) {
                    t = j2 - 2;
                    while (t >= s) {
                        m1[t] = -m1[j2];
                        --t;
                    }
                    m1[j2 - 1] = 3 * m1[j2];
                    m1[j2] = 0;
                }
            }
            --j2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int[][] determineW3Jsf(FlexiBigInt e0, FlexiBigInt e1) {
        d0 = e0.abs();
        d1 = e1.abs();
        n = d0.bitLength();
        if (d1.bitLength() != n) {
            throw new RuntimeException("e0 and e1 don't have the same bitlength");
        }
        m = new int[2][n + 1];
        u = n;
        c = 1;
        ** GOTO lbl205
        {
            m[0][u] = 0;
            m[1][u] = 0;
            --u;
            c = 1;
            do {
                if (u > 0 && d0.testBit(u) == d0.testBit(u - 1) && d1.testBit(u) == d1.testBit(u - 1)) continue block0;
                i = l = u - 1 - c;
                while (i <= u - 1 + c) {
                    if (i < n && i > 0) {
                        if (d0.testBit(i) && !d0.testBit(i - 1)) {
                            m[0][i] = -1;
                        }
                        if (!d0.testBit(i) && d0.testBit(i - 1)) {
                            m[0][i] = 1;
                        }
                        if (d1.testBit(i) && !d1.testBit(i - 1)) {
                            m[1][i] = -1;
                        }
                        if (!d1.testBit(i) && d1.testBit(i - 1)) {
                            m[1][i] = 1;
                        }
                    } else if (i == n) {
                        m[0][n] = 1;
                        m[1][n] = 1;
                    } else if (i == 0) {
                        if (d0.testBit(i)) {
                            m[0][0] = -1;
                        }
                        if (d1.testBit(i)) {
                            m[1][0] = -1;
                        }
                    }
                    ++i;
                }
                tmp0 = new int[u - l + 1];
                tmp1 = new int[u - l + 1];
                if (l >= 0) {
                    System.arraycopy(m[0], l, tmp0, 0, u - l + 1);
                    System.arraycopy(m[1], l, tmp1, 0, u - l + 1);
                } else {
                    System.arraycopy(m[0], 0, tmp0, -l, u + 1);
                    System.arraycopy(m[1], 0, tmp1, -l, u + 1);
                }
                z = ScalarMult.calculateZ(tmp0, tmp1, c);
                sum = 0;
                i = 0;
                while (i <= u - l) {
                    sum += z[i];
                    ++i;
                }
                if (sum >= 1 + c || l <= 0) {
                    ScalarMult.convert(tmp0, tmp1, z);
                    if (l >= 0) {
                        System.arraycopy(tmp0, 0, m[0], l, u - l + 1);
                        System.arraycopy(tmp1, 0, m[1], l, u - l + 1);
                    } else {
                        System.arraycopy(tmp0, -l, m[0], 0, u + 1);
                        System.arraycopy(tmp1, -l, m[1], 0, u + 1);
                    }
                    c = 1;
                    if ((u -= 2 + c) != 0) continue;
                    if (d0.testBit(0)) {
                        m[0][0] = -1;
                    }
                    if (!d1.testBit(0)) continue;
                    m[1][0] = -1;
                    continue;
                }
                i = l = u - 3 - c;
                while (i <= u - 1 + c) {
                    if (i < n && i > 0) {
                        if (d0.testBit(i) && !d0.testBit(i - 1)) {
                            m[0][i] = -1;
                        }
                        if (!d0.testBit(i) && d0.testBit(i - 1)) {
                            m[0][i] = 1;
                        }
                        if (d1.testBit(i) && !d1.testBit(i - 1)) {
                            m[1][i] = -1;
                        }
                        if (!d1.testBit(i) && d1.testBit(i - 1)) {
                            m[1][i] = 1;
                        }
                    } else if (i == n) {
                        m[0][n] = 1;
                        m[1][n] = 1;
                    } else if (i == 0) {
                        if (d0.testBit(i)) {
                            m[0][0] = -1;
                        }
                        if (d1.testBit(i)) {
                            m[1][0] = -1;
                        }
                    }
                    ++i;
                }
                tmp0 = new int[u - l + 1];
                tmp1 = new int[u - l + 1];
                if (l >= 0) {
                    System.arraycopy(m[0], l, tmp0, 0, u - l + 1);
                    System.arraycopy(m[1], l, tmp1, 0, u - l + 1);
                } else {
                    System.arraycopy(m[0], 0, tmp0, -l, u + 1);
                    System.arraycopy(m[1], 0, tmp1, -l, u + 1);
                }
                z = ScalarMult.calculateZ(tmp0, tmp1, c);
                if (z[3] == 1 && z[2] == 0 && z[1] == 1 && z[0] == 0) {
                    ScalarMult.convert(tmp0, tmp1, z);
                    if (l >= 0) {
                        System.arraycopy(tmp0, 0, m[0], l, u - l + 1);
                        System.arraycopy(tmp1, 0, m[1], l, u - l + 1);
                    } else {
                        System.arraycopy(tmp0, -l, m[0], 0, u + 1);
                        System.arraycopy(tmp1, -l, m[1], 0, u + 1);
                    }
                    u -= 4 + c;
                    c = 1;
                    continue;
                }
                i = l = u - 2 - c;
                while (i <= u - 1 + c) {
                    if (i < n && i > 0) {
                        if (d0.testBit(i) && !d0.testBit(i - 1)) {
                            m[0][i] = -1;
                        }
                        if (!d0.testBit(i) && d0.testBit(i - 1)) {
                            m[0][i] = 1;
                        }
                        if (d1.testBit(i) && !d1.testBit(i - 1)) {
                            m[1][i] = -1;
                        }
                        if (!d1.testBit(i) && d1.testBit(i - 1)) {
                            m[1][i] = 1;
                        }
                    } else if (i == n) {
                        m[0][n] = 1;
                        m[1][n] = 1;
                    } else if (i == 0) {
                        if (d0.testBit(i)) {
                            m[0][0] = -1;
                        }
                        if (d1.testBit(i)) {
                            m[1][0] = -1;
                        }
                    }
                    ++i;
                }
                tmp0 = new int[u - l + 1];
                tmp1 = new int[u - l + 1];
                if (l >= 0) {
                    System.arraycopy(m[0], l, tmp0, 0, u - l + 1);
                    System.arraycopy(m[1], l, tmp1, 0, u - l + 1);
                } else {
                    System.arraycopy(m[0], 0, tmp0, -l, u + 1);
                    System.arraycopy(m[1], 0, tmp1, -l, u + 1);
                }
                z = ScalarMult.calculateZ(tmp0, tmp1, c);
                ScalarMult.convert(tmp0, tmp1, z);
                if (l >= 0) {
                    System.arraycopy(tmp0, 0, m[0], l, u - l + 1);
                    System.arraycopy(tmp1, 0, m[1], l, u - l + 1);
                } else {
                    System.arraycopy(tmp0, -l, m[0], 0, u + 1);
                    System.arraycopy(tmp1, -l, m[1], 0, u + 1);
                }
                left0 = new int[2];
                left1 = new int[2];
                System.arraycopy(m[0], l, left0, 0, 2);
                System.arraycopy(m[1], l, left1, 0, 2);
                right0 = new int[2];
                right1 = new int[2];
                if (l < n && l > 0) {
                    if (d0.testBit(l) && !d0.testBit(l - 1)) {
                        right0[0] = -1;
                    }
                    if (!d0.testBit(l) && d0.testBit(l - 1)) {
                        right0[0] = 1;
                    }
                    if (d1.testBit(l) && !d1.testBit(l - 1)) {
                        right1[0] = -1;
                    }
                    if (!d1.testBit(l) && d1.testBit(l - 1)) {
                        right1[0] = 1;
                    }
                } else if (l == n) {
                    right0[0] = 1;
                    right1[0] = 1;
                } else if (l == 0) {
                    if (d0.testBit(l)) {
                        right0[0] = -1;
                    }
                    if (d1.testBit(l)) {
                        right1[0] = -1;
                    }
                }
                if (l - 1 < n && l - 1 > 0) {
                    if (d0.testBit(l - 1) && !d0.testBit(l - 2)) {
                        right0[1] = -1;
                    }
                    if (!d0.testBit(l - 1) && d0.testBit(l - 2)) {
                        right0[1] = 1;
                    }
                    if (d1.testBit(l - 1) && !d1.testBit(l - 2)) {
                        right1[1] = -1;
                    }
                    if (!d1.testBit(l - 1) && d1.testBit(l - 2)) {
                        right1[1] = 1;
                    }
                } else if (l - 1 == n) {
                    right0[1] = 1;
                    right1[1] = 1;
                } else if (l - 1 == 0) {
                    if (d0.testBit(l)) {
                        right0[0] = -1;
                    }
                    if (d1.testBit(l)) {
                        right1[0] = -1;
                    }
                }
                if (right0.equals(left0) && right1.equals(left1)) {
                    u -= 1 + c;
                    c = 1;
                    continue;
                }
                if (!(m[0][l] == -3 && m[0][l] != 3 || m[1][l] == -3 && m[1][l] != 3 || m[0][l] != 0 || m[1][l] != 0)) {
                    u -= 2 + c;
                    c = 0;
                    continue;
                }
                u -= 3 + c;
                c = 1;
lbl205:
                // 8 sources

            } while (u > 0);
        }
        if (e0.signum() == -1) {
            i = 0;
            while (i < m[0].length) {
                if (m[0][i] != 0) {
                    m[0][i] = -m[0][i];
                }
                ++i;
            }
        }
        if (e1.signum() == -1) {
            i = 0;
            while (i < m[1].length) {
                if (m[1][i] != 0) {
                    m[1][i] = -m[1][i];
                }
                ++i;
            }
        }
        return m;
    }

    public static int[][] determineSimultaneous2w_rtl(FlexiBigInt d1, FlexiBigInt d2, int w) {
        int l;
        int j;
        int s2;
        int s1;
        int b2;
        FlexiBigInt e1 = d1.abs();
        FlexiBigInt e2 = d2.abs();
        int b1 = e1.bitLength();
        int b = b1 < (b2 = e2.bitLength()) ? b2 : b1;
        int[][] N = new int[2][b];
        int i = b - 1;
        int t = (i + 1) % w;
        if (t != 0) {
            s1 = 0;
            s2 = 0;
            j = 0;
            while (j < t) {
                s1 <<= 1;
                s2 <<= 1;
                if (e1.testBit(i - j)) {
                    ++s1;
                }
                if (e2.testBit(i - j)) {
                    ++s2;
                }
                ++j;
            }
            N[0][i - t + 1] = s1;
            N[1][i - t + 1] = s2;
        }
        i -= t;
        while (i >= 0) {
            s1 = 0;
            s2 = 0;
            j = i;
            while (j > i - w) {
                s1 <<= 1;
                s2 <<= 1;
                if (e1.testBit(j)) {
                    ++s1;
                }
                if (e2.testBit(j)) {
                    ++s2;
                }
                --j;
            }
            if (s1 + s2 > 0) {
                N[0][i - w + 1] = s1;
                N[1][i - w + 1] = s2;
            }
            i -= w;
        }
        if (d1.signum() == -1) {
            l = 0;
            while (l < N[0].length) {
                if (N[0][l] != 0) {
                    N[0][l] = -N[0][l];
                }
                ++l;
            }
        }
        if (d2.signum() == -1) {
            l = 0;
            while (l < N[1].length) {
                if (N[1][l] != 0) {
                    N[1][l] = -N[1][l];
                }
                ++l;
            }
        }
        return N;
    }

    public static int[][] determineSimultaneous2w_ltr(FlexiBigInt d1, FlexiBigInt d2, int w) {
        int l;
        int j;
        int s2;
        int s1;
        int b2;
        FlexiBigInt e1 = d1.abs();
        FlexiBigInt e2 = d2.abs();
        int b1 = e1.bitLength();
        int b = b1 < (b2 = e2.bitLength()) ? b2 : b1;
        int[][] N = new int[2][b];
        int i = b - 1;
        int t = (i + 1) % w;
        while (i + 1 >= w) {
            s1 = 0;
            s2 = 0;
            j = i;
            while (j > i - w) {
                s1 <<= 1;
                s2 <<= 1;
                if (e1.testBit(j)) {
                    ++s1;
                }
                if (e2.testBit(j)) {
                    ++s2;
                }
                --j;
            }
            if (s1 + s2 > 0) {
                N[0][i - w + 1] = s1;
                N[1][i - w + 1] = s2;
            }
            i -= w;
        }
        if (t != 0) {
            s1 = 0;
            s2 = 0;
            j = 0;
            while (j < t) {
                s1 <<= 1;
                s2 <<= 1;
                if (e1.testBit(i - j)) {
                    ++s1;
                }
                if (e2.testBit(i - j)) {
                    ++s2;
                }
                ++j;
            }
            N[0][0] = s1;
            N[1][0] = s2;
        }
        if (d1.signum() == -1) {
            l = 0;
            while (l < N[0].length) {
                if (N[0][l] != 0) {
                    N[0][l] = -N[0][l];
                }
                ++l;
            }
        }
        if (d2.signum() == -1) {
            l = 0;
            while (l < N[1].length) {
                if (N[1][l] != 0) {
                    N[1][l] = -N[1][l];
                }
                ++l;
            }
        }
        return N;
    }

    public static int[][] determineSimultaneousSW(FlexiBigInt d1, FlexiBigInt d2, int w) {
        int l;
        int b2;
        FlexiBigInt e1 = d1.abs();
        FlexiBigInt e2 = d2.abs();
        int b1 = e1.bitLength();
        int b = b1 < (b2 = e2.bitLength()) ? b2 : b1;
        int[][] sw = new int[2][b + 1];
        int jNew = 0;
        int J = 0;
        int j = b - 1;
        while (j >= 0) {
            if (!e1.testBit(j) && !e2.testBit(j)) {
                --j;
                continue;
            }
            jNew = j - w > -1 ? j - w : -1;
            J = jNew + 1;
            while (!e1.testBit(J) && !e2.testBit(J)) {
                ++J;
            }
            int s1 = 0;
            int s2 = 0;
            int i = j;
            while (i >= J) {
                s1 <<= 1;
                s2 <<= 1;
                if (e1.testBit(i)) {
                    ++s1;
                }
                if (e2.testBit(i)) {
                    ++s2;
                }
                --i;
            }
            sw[0][J] = s1;
            sw[1][J] = s2;
            j -= j - J + 1;
        }
        if (d1.signum() == -1) {
            l = 0;
            while (l < sw[0].length) {
                if (sw[0][l] != 0) {
                    sw[0][l] = -sw[0][l];
                }
                ++l;
            }
        }
        if (d2.signum() == -1) {
            l = 0;
            while (l < sw[1].length) {
                if (sw[1][l] != 0) {
                    sw[1][l] = -sw[1][l];
                }
                ++l;
            }
        }
        return sw;
    }

    public static int[][] determineSimultaneousNaf(FlexiBigInt[] e, int[] w) {
        int b = 0;
        int i = 0;
        while (i < e.length) {
            b = b < e[i].bitLength() ? e[i].bitLength() : b;
            ++i;
        }
        int[][] N = new int[e.length][b + 1];
        int i2 = 0;
        while (i2 < e.length) {
            ScalarMult.determineNaf(N[i2], e[i2], w[i2]);
            ++i2;
        }
        return N;
    }

    public static Point eval_SquareMultiply(FlexiBigInt m, Point p) {
        int l;
        Point P = (Point)p.clone();
        Point H = ScalarMult.createZeroPoint(p, p, p.getE());
        if (m.compareTo(FlexiBigInt.ZERO) == -1) {
            m = m.negate();
            P = P.negate();
        }
        if (P.isZero() || m.equals(FlexiBigInt.ZERO)) {
            return H;
        }
        if (m.equals(FlexiBigInt.ONE)) {
            return P;
        }
        int i = l = m.bitLength() - 1;
        while (i >= 0) {
            if (m.testBit(i)) {
                H.multiplyThisBy2();
                H = P.add(H);
            } else {
                H.multiplyThisBy2();
            }
            --i;
        }
        return H.getAffin();
    }

    public static Point eval_SquareMultiply(int[] N, Point[] P) {
        int l;
        Point r = ScalarMult.createZeroPoint(P[0], P[0], P[0].getE());
        int i = l = N.length - 1;
        while (i >= 0) {
            r.multiplyThisBy2();
            int index = N[i];
            if (index > 0) {
                r.addToThis(P[index - 1 >> 1]);
            } else if (index < 0) {
                r.subtractFromThis(P[-index - 1 >> 1]);
            }
            --i;
        }
        return r.getAffin();
    }

    public static Point eval_SquareMultiply_all(int[] N, Point[] P) {
        int l;
        Point r = ScalarMult.createZeroPoint(P[0], P[0], P[0].getE());
        int i = l = N.length - 1;
        while (i >= 0) {
            if (N[i] != 0) {
                r.multiplyThisBy2();
                r = r.add(P[N[i] - 1]);
            } else {
                r.multiplyThisBy2();
            }
            --i;
        }
        return r.getAffin();
    }

    public static Point eval_shamir(Point P, Point Q, FlexiBigInt e1, FlexiBigInt e2) {
        int t = e1.bitLength() >= e2.bitLength() ? e1.bitLength() : e2.bitLength();
        Point G1 = (Point)P.clone();
        Point G2 = (Point)Q.clone();
        Point G3 = P.add(Q);
        Point r = ScalarMult.createZeroPoint(P, Q, Q.getE());
        int i = t - 1;
        while (i >= 0) {
            r.multiplyThisBy2();
            if (e1.testBit(i) && e2.testBit(i)) {
                r = G3.add(r);
            }
            if (e1.testBit(i) && !e2.testBit(i)) {
                r = G1.add(r);
            }
            if (!e1.testBit(i) && e2.testBit(i)) {
                r = G2.add(r);
            }
            --i;
        }
        return r.getAffin();
    }

    public static Point eval_shamir_all(int[][] N, Point[][] P) {
        int t = N[0].length >= N[1].length ? N[0].length - 1 : N[1].length - 1;
        Point r = ScalarMult.createZeroPoint(P[0][1], P[1][0], P[0][1].getE());
        int i = t;
        while (i >= 0) {
            r.multiplyThisBy2();
            int z1 = 0;
            int z2 = 0;
            if (i < N[0].length && N[0][i] != 0) {
                z1 = N[0][i];
            }
            if (i < N[1].length && N[1][i] != 0) {
                z2 = N[1][i];
            }
            if (i < N[0].length && N[0][i] != 0 || i < N[1].length && N[1][i] != 0) {
                r = r.add(P[z1][z2]);
            }
            --i;
        }
        return r.getAffin();
    }

    public static Point eval_shamir(int[][] N, Point[][] P) {
        int t = N[0].length >= N[1].length ? N[0].length - 1 : N[1].length - 1;
        Point r = ScalarMult.createZeroPoint(P[0][1], P[1][0], P[0][1].getE());
        int i = t;
        while (i >= 0) {
            r.multiplyThisBy2();
            int z1 = 0;
            int z2 = 0;
            if (i < N[0].length && N[0][i] != 0) {
                if (N[0][i] >= 0) {
                    z1 = N[0][i];
                } else if (N[0][i] < 0) {
                    z1 = -N[0][i] + 1;
                }
            }
            if (i < N[1].length && N[1][i] != 0) {
                if (N[1][i] >= 0) {
                    z2 = N[1][i];
                } else if (N[1][i] < 0) {
                    z2 = -N[1][i] + 1;
                }
            }
            if (i < N[0].length && N[0][i] != 0 || i < N[1].length && N[1][i] != 0) {
                r = r.add(P[z1][z2]);
            }
            --i;
        }
        return r.getAffin();
    }

    public static Point eval_shamir(int[][] N, Point[][][] P) {
        int t = N[0].length - 1;
        int i = 1;
        while (i < N.length) {
            t = N[i].length - 1 > t ? N[i].length - 1 : t;
            ++i;
        }
        Point r = ScalarMult.createZeroPoint(P[0][0][0], P[0][0][0], P[0][0][0].getE());
        int i2 = t;
        while (i2 >= 0) {
            r.multiplyThisBy2();
            int z1 = 0;
            int z2 = 0;
            int z3 = 0;
            if (i2 < N[0].length && N[0][i2] != 0) {
                if (N[0][i2] >= 0) {
                    z1 = N[0][i2];
                } else if (N[0][i2] < 0) {
                    z1 = -N[0][i2] + 1;
                }
            }
            if (i2 < N[1].length && N[1][i2] != 0) {
                if (N[1][i2] >= 0) {
                    z2 = N[1][i2];
                } else if (N[1][i2] < 0) {
                    z2 = -N[1][i2] + 1;
                }
            }
            if (i2 < N[2].length && N[2][i2] != 0) {
                if (N[2][i2] >= 0) {
                    z3 = N[2][i2];
                } else if (N[2][i2] < 0) {
                    z3 = -N[2][i2] + 1;
                }
            }
            if (N[0][i2] != 0 || N[1][i2] != 0 || N[2][i2] != 0) {
                r = r.add(P[z1][z2][z3]);
            }
            --i2;
        }
        return r.getAffin();
    }

    public static Point eval_shamir(int[][] N, Point[][][][] P) {
        int t = N[0].length - 1;
        int i = 1;
        while (i < N.length) {
            t = N[i].length - 1 > t ? N[i].length - 1 : t;
            ++i;
        }
        Point r = ScalarMult.createZeroPoint(P[0][0][0][0], P[0][0][0][0], P[0][0][0][0].getE());
        int i2 = t;
        while (i2 >= 0) {
            r.multiplyThisBy2();
            int z1 = 0;
            int z2 = 0;
            int z3 = 0;
            int z4 = 0;
            if (i2 < N[0].length && N[0][i2] != 0) {
                if (N[0][i2] >= 0) {
                    z1 = N[0][i2];
                } else if (N[0][i2] < 0) {
                    z1 = -N[0][i2] + 1;
                }
            }
            if (i2 < N[1].length && N[1][i2] != 0) {
                if (N[1][i2] >= 0) {
                    z2 = N[1][i2];
                } else if (N[1][i2] < 0) {
                    z2 = -N[1][i2] + 1;
                }
            }
            if (i2 < N[2].length && N[2][i2] != 0) {
                if (N[2][i2] >= 0) {
                    z3 = N[2][i2];
                } else if (N[2][i2] < 0) {
                    z3 = -N[2][i2] + 1;
                }
            }
            if (i2 < N[3].length && N[3][i2] != 0) {
                if (N[3][i2] >= 0) {
                    z4 = N[3][i2];
                } else if (N[3][i2] < 0) {
                    z4 = -N[3][i2] + 1;
                }
            }
            if (N[0][i2] != 0 || N[1][i2] != 0 || N[2][i2] != 0 || N[3][i2] != 0) {
                r = r.add(P[z1][z2][z3][z4]);
            }
            --i2;
        }
        return r.getAffin();
    }

    public static Point eval_interleaving(int[][] N, Point[][] P) {
        Point r = ScalarMult.createZeroPoint(P[0][0], P[0][0], P[0][0].getE());
        int t = N[0].length - 1;
        int i = 1;
        while (i < N.length) {
            t = N[i].length - 1 > t ? N[i].length - 1 : t;
            ++i;
        }
        int j = t;
        while (j >= 0) {
            r.multiplyThisBy2();
            int i2 = 0;
            while (i2 < N.length) {
                if (j < N[i2].length) {
                    if (N[i2][j] > 0) {
                        r = P[i2][N[i2][j] - 1 >> 1].add(r);
                    } else if (N[i2][j] < 0) {
                        r = r.subtract(P[i2][-N[i2][j] - 1 >> 1]);
                    }
                }
                ++i2;
            }
            --j;
        }
        return r;
    }

    private static Point createZeroPoint(Object type1, Object type2, Object curve) {
        if (type1 instanceof PointGFP && type2 instanceof PointGFP && curve instanceof EllipticCurveGFP) {
            return new PointGFP((EllipticCurveGFP)curve);
        }
        if (type1 instanceof PointGF2n && type2 instanceof PointGF2n && curve instanceof EllipticCurveGF2n) {
            return new PointGF2n((EllipticCurveGF2n)curve);
        }
        return null;
    }

    private static Point[][] createPointMatrix(Object type1, Object type2, int cols, int rows) {
        if (type1 instanceof PointGFP && type2 instanceof PointGFP) {
            return new PointGFP[cols][rows];
        }
        if (type1 instanceof PointGF2n && type2 instanceof PointGF2n) {
            return new PointGF2n[cols][rows];
        }
        return null;
    }

    private static GF2nElement createGF2nOneElement(GF2nField gf2n) {
        if (gf2n instanceof GF2nONBField) {
            return GF2nONBElement.ONE((GF2nONBField)gf2n);
        }
        return GF2nPolynomialElement.ONE((GF2nPolynomialField)gf2n);
    }
}

