/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.common.exceptions;

import de.flexiprovider.api.exceptions.InvalidParameterException;

public class UnknownOIDException
extends InvalidParameterException {
    public UnknownOIDException() {
        super("This OID is unknown to this provider.");
    }

    public UnknownOIDException(String oid) {
        super("OID " + oid + " is unknown to this provider.");
    }

    public UnknownOIDException(int[] oid) {
        super("OID " + UnknownOIDException.oidToString(oid) + " is unknown to this provider.");
    }

    private static String oidToString(int[] oid) {
        String result = "";
        int i = 0;
        while (i < oid.length - 1) {
            result = result + oid[i] + ".";
            ++i;
        }
        result = result + oid[oid.length - 1];
        return result;
    }
}

