/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.api;

import de.flexiprovider.api.exceptions.InvalidAlgorithmParameterException;
import de.flexiprovider.api.exceptions.InvalidKeyException;
import de.flexiprovider.api.exceptions.ShortBufferException;
import de.flexiprovider.api.keys.SecretKey;
import de.flexiprovider.api.parameters.AlgorithmParameterSpec;
import java.security.Key;
import javax.crypto.MacSpi;

public abstract class Mac
extends MacSpi {
    protected final int engineGetMacLength() {
        return this.getMacLength();
    }

    protected void engineInit(Key key, java.security.spec.AlgorithmParameterSpec params) throws java.security.InvalidKeyException, java.security.InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) {
            throw new java.security.InvalidKeyException();
        }
        if (params != null && !(params instanceof AlgorithmParameterSpec)) {
            throw new java.security.InvalidAlgorithmParameterException();
        }
        this.init((SecretKey)key, (AlgorithmParameterSpec)params);
    }

    protected final void engineUpdate(byte input) {
        this.update(input);
    }

    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.update(input, offset, len);
    }

    protected final byte[] engineDoFinal() {
        return this.doFinal();
    }

    protected final void engineReset() {
        this.reset();
    }

    public abstract int getMacLength();

    public final void init(SecretKey key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new IllegalArgumentException("This MAC needs parameters");
        }
    }

    public abstract void init(SecretKey var1, AlgorithmParameterSpec var2) throws InvalidAlgorithmParameterException, InvalidKeyException;

    public abstract void update(byte var1);

    public final void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] doFinal();

    public final byte[] doFinal(byte[] input) {
        this.update(input);
        return this.doFinal();
    }

    public final int doFinal(byte[] output, int outOffset) throws ShortBufferException {
        if (output.length - outOffset < this.getMacLength()) {
            throw new ShortBufferException();
        }
        byte[] mac = this.doFinal();
        System.arraycopy(mac, 0, output, outOffset, mac.length);
        return mac.length;
    }

    public abstract void reset();
}

