/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class ParserSupport {
    private static final Map<String, TimeUnit> TIMEUNITS = new HashMap<String, TimeUnit>();

    public static long millis(String time, String timeUnit) {
        return TIMEUNITS.get(timeUnit).toMillis(Long.parseLong(time));
    }

    public static long millis(String time) {
        int s = time.length() - 1;
        while (time.charAt(s) > '9') {
            --s;
        }
        return ParserSupport.millis(time.substring(0, s + 1), time.substring(s + 1));
    }

    public static String unquote(String s) {
        char last;
        if (s == null || s.length() < 2) {
            return s;
        }
        char first = s.charAt(0);
        if (first == (last = s.charAt(s.length() - 1)) && (first == '\'' || first == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    static {
        TIMEUNITS.put("d", TimeUnit.DAYS);
        TIMEUNITS.put("h", TimeUnit.HOURS);
        TIMEUNITS.put("m", TimeUnit.MINUTES);
        TIMEUNITS.put("s", TimeUnit.SECONDS);
        TIMEUNITS.put("ms", TimeUnit.MILLISECONDS);
    }
}

