/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.logging.Messages;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.logging.LogFactory;

public class UpgradeStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(UpgradeStatement.class, Log.class);
    final String cacheName;
    private final List<Option> options;

    public UpgradeStatement(List<Option> options, String cacheName) {
        this.options = options;
        this.cacheName = cacheName;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        boolean all = false;
        UpgradeMode mode = UpgradeMode.NONE;
        String migratorName = null;
        for (Option opt : this.options) {
            switch (opt.toEnum(Options.class)) {
                case ALL: {
                    all = true;
                    break;
                }
                case DUMPKEYS: {
                    mode = UpgradeMode.DUMPKEYS;
                    break;
                }
                case SYNCHRONIZE: {
                    mode = UpgradeMode.SYNCHRONIZE;
                    migratorName = opt.getParameter();
                    if (migratorName != null) break;
                    throw log.missingMigrator();
                }
                case DISCONNECTSOURCE: {
                    mode = UpgradeMode.DISCONNECTSOURCE;
                    migratorName = opt.getParameter();
                    if (migratorName != null) break;
                    throw log.missingMigrator();
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        switch (mode) {
            case DUMPKEYS: {
                for (Cache<?, ?> cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    upgradeManager.recordKnownGlobalKeyset();
                    sb.append(Messages.MSG.dumpedKeys(cache.getName()));
                    sb.append("\n");
                }
                break;
            }
            case SYNCHRONIZE: {
                for (Cache<?, ?> cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    try {
                        long count = upgradeManager.synchronizeData(migratorName);
                        sb.append(Messages.MSG.synchronizedEntries(count, migratorName, cache.getName()));
                        sb.append("\n");
                    }
                    catch (Exception e) {
                        throw log.dataSynchronizationError(e, cache.getName(), migratorName);
                    }
                }
                break;
            }
            case DISCONNECTSOURCE: {
                for (Cache<?, ?> cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    try {
                        upgradeManager.disconnectSource(migratorName);
                        sb.append(Messages.MSG.disonnectedSource(migratorName, cache.getName()));
                        sb.append("\n");
                    }
                    catch (Exception e) {
                        throw log.sourceDisconnectionError(e, cache.getName(), migratorName);
                    }
                }
                break;
            }
            default: {
                throw log.missingUpgradeAction();
            }
        }
        return new StringResult(sb.toString());
    }

    private List<Cache<?, ?>> getAllCaches(Session session) {
        ArrayList caches = new ArrayList();
        EmbeddedCacheManager container = session.getCacheManager();
        for (String cacheName : container.getCacheNames()) {
            if (!container.isRunning(cacheName)) continue;
            caches.add(session.getCache(cacheName));
        }
        caches.add(container.getCache());
        return caches;
    }

    private static enum UpgradeMode {
        NONE,
        DUMPKEYS,
        SYNCHRONIZE,
        DISCONNECTSOURCE;

    }

    private static enum Options {
        ALL,
        DUMPKEYS,
        SYNCHRONIZE,
        DISCONNECTSOURCE;

    }
}

