/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.InconsistentStateException;
import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Choice;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1GeneralizedTime;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1UTCTime;
import codec.asn1.ConstraintException;
import codec.asn1.DERDecoder;
import codec.asn1.DEREncoder;
import codec.util.JCA;
import codec.x501.Name;
import codec.x509.AlgorithmIdentifier;
import codec.x509.SubjectPublicKeyInfo;
import codec.x509.X509Extension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.util.AbstractList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;

public class X509TBSCertificate
extends ASN1Sequence
implements Externalizable {
    public static final int DEFAULT_VERSION = 2;
    private ASN1Integer version_ = new ASN1Integer(2);
    private ASN1TaggedType versionTag_ = new ASN1TaggedType(0, this.version_, true, false);
    private ASN1Integer serialNumber_ = null;
    private AlgorithmIdentifier signature_ = null;
    private Name issuer_ = null;
    private ASN1Choice notBefore_ = null;
    private ASN1Choice notAfter_ = null;
    private Name subject_ = null;
    private SubjectPublicKeyInfo subjectPublicKeyInfo_ = null;
    private ASN1BitString issuerUniqueID_ = null;
    private ASN1TaggedType issuerUniqueIDTag_ = null;
    private ASN1BitString subjectUniqueID_ = null;
    private ASN1TaggedType subjectUniqueIDTag_ = null;
    private ASN1SequenceOf extensions_ = null;
    private ASN1TaggedType extensionsTag_ = null;
    static /* synthetic */ Class class$codec$x509$X509Extension;

    public X509TBSCertificate() {
        super(10);
        this.add(this.versionTag_);
        this.serialNumber_ = new ASN1Integer();
        this.add(this.serialNumber_);
        this.signature_ = new AlgorithmIdentifier();
        this.add(this.signature_);
        this.issuer_ = new Name();
        this.add(this.issuer_);
        ASN1Sequence validity = new ASN1Sequence();
        this.notBefore_ = new ASN1Choice();
        this.notBefore_.addType(new ASN1UTCTime());
        this.notBefore_.addType(new ASN1GeneralizedTime());
        validity.add(this.notBefore_);
        this.notAfter_ = new ASN1Choice();
        this.notAfter_.addType(new ASN1UTCTime());
        this.notAfter_.addType(new ASN1GeneralizedTime());
        validity.add(this.notAfter_);
        this.add(validity);
        this.subject_ = new Name();
        this.add(this.subject_);
        this.subjectPublicKeyInfo_ = new SubjectPublicKeyInfo();
        this.add(this.subjectPublicKeyInfo_);
        this.issuerUniqueID_ = new ASN1BitString();
        this.issuerUniqueIDTag_ = new ASN1TaggedType(1, this.issuerUniqueID_, false, true);
        this.add(this.issuerUniqueIDTag_);
        this.subjectUniqueID_ = new ASN1BitString();
        this.subjectUniqueIDTag_ = new ASN1TaggedType(2, this.subjectUniqueID_, false, true);
        this.add(this.subjectUniqueIDTag_);
        this.extensions_ = new ASN1SequenceOf(class$codec$x509$X509Extension == null ? (class$codec$x509$X509Extension = X509TBSCertificate.class$("codec.x509.X509Extension")) : class$codec$x509$X509Extension);
        this.extensionsTag_ = new ASN1TaggedType(3, this.extensions_, true, true);
        this.add(this.extensionsTag_);
    }

    public void addExtension(X509Extension ext) {
        this.extensions_.add(ext);
        this.extensionsTag_.setOptional(false);
    }

    public int getBasicConstraints() {
        int res = -1;
        String bc_oid = "2.5.29.19";
        byte[] ext_value = this.getExtensionValue(bc_oid);
        if (ext_value != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(ext_value);
            try {
                ASN1Sequence seq = new ASN1Sequence();
                ASN1Boolean ca = new ASN1Boolean();
                ca.setOptional(true);
                seq.add(ca);
                ASN1Integer pathLen = new ASN1Integer();
                pathLen.setOptional(true);
                seq.add(pathLen);
                DERDecoder dec = new DERDecoder(bais);
                seq.decode(dec);
                bais.close();
                if (ca.isTrue()) {
                    res = pathLen.getBigInteger().intValue();
                }
            }
            catch (Exception e) {
                System.out.println("gbc Internal Error.Shouldnt happen");
                e.printStackTrace();
            }
        }
        return res;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> res = new HashSet<String>();
        if (this.extensionsTag_.isOptional()) {
            return null;
        }
        try {
            Iterator it = ((AbstractList)this.extensions_).iterator();
            while (it.hasNext()) {
                X509Extension theEx = (X509Extension)it.next();
                if (!theEx.isCritical()) continue;
                res.add(theEx.getOID().toString());
            }
        }
        catch (Exception ignore) {
            System.out.println("gcritoid Internal Error.Shouldnt happen");
            ignore.printStackTrace();
        }
        return res;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        byte[] res = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(new DEREncoder(baos));
            res = baos.toByteArray();
            baos.close();
        }
        catch (IOException e) {
            System.out.println("internal error:");
            e.printStackTrace();
        }
        catch (ASN1Exception e) {
            throw new CertificateEncodingException(e.getMessage());
        }
        return res;
    }

    public Collection getExtensions() {
        if (this.extensionsTag_.isOptional()) {
            return null;
        }
        return this.extensions_;
    }

    public byte[] getExtensionValue(String ex) {
        byte[] res = null;
        if (this.extensionsTag_.isOptional()) {
            return null;
        }
        try {
            Iterator it = ((AbstractList)this.extensions_).iterator();
            while (it.hasNext()) {
                X509Extension theEx = (X509Extension)it.next();
                if (!theEx.getOID().toString().equals(ex)) continue;
                res = (byte[])theEx.getValue();
                break;
            }
        }
        catch (Exception ignore) {
            System.out.println("getextval Internal Error.Shouldnt happen");
            ignore.printStackTrace();
        }
        return res;
    }

    public Principal getIssuerDN() {
        return this.issuer_;
    }

    public boolean[] getIssuerUniqueID() {
        if (this.issuerUniqueIDTag_.isOptional()) {
            return null;
        }
        return this.issuerUniqueID_.getBits();
    }

    public boolean[] getKeyUsage() {
        boolean[] res = null;
        String ku_oid = "2.5.29.15";
        byte[] ext_value = this.getExtensionValue(ku_oid);
        if (ext_value != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(ext_value);
            try {
                ASN1BitString bits = new ASN1BitString();
                DERDecoder dec = new DERDecoder(bais);
                bits.decode(dec);
                bais.close();
                res = bits.getBits();
            }
            catch (Exception e) {
                System.out.println("Internal Error.Shouldnt happen");
                e.printStackTrace();
            }
        }
        return res;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<int[]> res = new HashSet<int[]>();
        if (this.extensionsTag_.isOptional()) {
            return null;
        }
        try {
            Iterator it = ((AbstractList)this.extensions_).iterator();
            while (it.hasNext()) {
                X509Extension theEx = (X509Extension)it.next();
                if (theEx.isCritical()) continue;
                res.add(theEx.getOID().getOID());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public Date getNotAfter() {
        return ((ASN1Time)this.notAfter_.getInnerType()).getDate();
    }

    public Date getNotBefore() {
        return ((ASN1Time)this.notBefore_.getInnerType()).getDate();
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException {
        return this.subjectPublicKeyInfo_.getPublicKey();
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber_.getBigInteger();
    }

    public String getSigAlgName() {
        return JCA.getName(this.getSigAlgOID());
    }

    public String getSigAlgOID() {
        return this.signature_.getAlgorithmOID().toString();
    }

    public byte[] getSigAlgParams() {
        byte[] res = null;
        try {
            res = this.signature_.getParameters().getEncoded();
        }
        catch (Exception intern) {
            System.out.println("internal Error:");
            intern.printStackTrace();
        }
        return res;
    }

    public Principal getSubjectDN() {
        return this.subject_;
    }

    public boolean[] getSubjectUniqueID() {
        if (this.issuerUniqueIDTag_.isOptional()) {
            return null;
        }
        return this.issuerUniqueID_.getBits();
    }

    public int getVersion() {
        if (this.versionTag_.isOptional()) {
            return 0;
        }
        return this.version_.getBigInteger().intValue();
    }

    public void setVersion(int version) {
        if (version < 0 || version > 2) {
            throw new IllegalArgumentException("illegal version number: " + version);
        }
        if (version < 2 && !this.extensionsTag_.isOptional()) {
            throw new IllegalArgumentException("can't set to " + version + ", extensions are present");
        }
        boolean opt = version == 0;
        ASN1TaggedType tt = new ASN1TaggedType(0, new ASN1Integer(version), true, opt);
        this.set(0, tt);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public void setIssuerDN(Principal nissuer, int encType) {
        if (nissuer instanceof Name) {
            this.issuer_ = (Name)nissuer;
        } else {
            try {
                this.issuer_ = new Name(nissuer.getName(), encType);
            }
            catch (Exception e) {
                System.out.println("Internal Error:");
                e.printStackTrace();
                return;
            }
        }
        this.set(3, this.issuer_);
    }

    public void setIssuerDN(Principal nissuer) {
        if (nissuer instanceof Name) {
            this.issuer_ = (Name)nissuer;
        } else {
            try {
                this.issuer_ = new Name(nissuer.getName(), 19);
            }
            catch (Exception e) {
                System.out.println("Internal Error:");
                e.printStackTrace();
                return;
            }
        }
        this.set(3, this.issuer_);
    }

    public void setIssuerUniqueID(byte[] nid) {
        try {
            this.issuerUniqueID_.setBits(nid, 0);
            this.issuerUniqueIDTag_.setOptional(false);
        }
        catch (ConstraintException e) {
            System.out.println("internal error. shouldnt happen:");
            e.printStackTrace();
        }
    }

    public void setNotAfter(Calendar nnaf) {
        ASN1Time nai = (ASN1Time)this.notAfter_.getInnerType();
        if (nai == null) {
            nai = new ASN1UTCTime();
            this.notAfter_.setInnerType(nai);
        }
        nai.setDate(nnaf);
    }

    public void setNotAfter(Date nnaf) {
        Calendar x = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        x.setTime(nnaf);
        this.setNotAfter(x);
    }

    public void setNotBefore(Calendar nnbf) {
        ASN1Time nai = (ASN1Time)this.notBefore_.getInnerType();
        if (nai == null) {
            nai = new ASN1UTCTime();
            this.notBefore_.setInnerType(nai);
        }
        nai.setDate(nnbf);
    }

    public void setNotBefore(Date nnbf) {
        Calendar x = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        x.setTime(nnbf);
        this.setNotBefore(x);
    }

    public void setSerialNumber(int nsnr) {
        this.setSerialNumber(new BigInteger(String.valueOf(nsnr), 10));
    }

    public void setSerialNumber(BigInteger nsnr) {
        try {
            this.serialNumber_.setBigInteger(nsnr);
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier aid) {
        this.signature_ = (AlgorithmIdentifier)aid.clone();
        this.set(2, this.signature_);
    }

    public void setSubjectDN(Principal nsubject) {
        if (nsubject instanceof Name) {
            this.subject_ = (Name)nsubject;
        } else {
            try {
                this.subject_ = new Name(nsubject.getName(), 22);
            }
            catch (Exception e) {
                System.out.println("Internal Error:");
                e.printStackTrace();
                return;
            }
        }
        this.set(5, this.subject_);
    }

    public void setSubjectDN(Principal nsubject, int encType) {
        if (nsubject instanceof Name) {
            this.subject_ = (Name)nsubject;
        } else {
            try {
                this.subject_ = new Name(nsubject.getName(), encType);
            }
            catch (Exception e) {
                System.out.println("Internal Error:");
                e.printStackTrace();
                return;
            }
        }
        this.set(5, this.subject_);
    }

    public void setSubjectPublicKey(PublicKey pk) throws InvalidKeyException {
        this.subjectPublicKeyInfo_.setPublicKey(pk);
    }

    public void setSubjectUniqueID(byte[] nid) {
        try {
            this.subjectUniqueID_.setBits(nid, 0);
            this.subjectUniqueIDTag_.setOptional(false);
        }
        catch (ConstraintException e) {
            System.out.println("internal error. shouldnt happen:");
            e.printStackTrace();
        }
        if (this.extensionsTag_.isOptional() || this.versionTag_.isOptional()) {
            this.versionTag_.setOptional(false);
            try {
                this.version_.setBigInteger(new BigInteger("1"));
            }
            catch (ConstraintException constraintException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        String res = "";
        int vrs = this.versionTag_.isOptional() ? 1 : this.version_.getBigInteger().intValue() + 1;
        res = "TBS Certificate {";
        res = res + "\nX509 certificate V" + vrs;
        res = res + "\nserial number:" + this.serialNumber_.toString();
        res = res + "\nsignature algorithm:" + this.signature_.toString();
        res = res + "\nissuer:" + this.issuer_.getName();
        res = res + "\nsubject:" + this.subject_.getName();
        res = res + "\nvalidity:" + ((ASN1Time)this.notBefore_.getInnerType()).toString();
        res = res + " - " + ((ASN1Time)this.notAfter_.getInnerType()).toString();
        res = res + "\nsubject public key algorithm:" + this.subjectPublicKeyInfo_.getAlgorithmIdentifier().toString();
        res = res + "\nsubject public key:";
        try {
            res = res + "\n" + this.subjectPublicKeyInfo_.getPublicKey().toString();
        }
        catch (InconsistentStateException ise) {
            res = res + "<key data corrupted!>";
        }
        catch (NoSuchAlgorithmException cce) {
            res = res + "<key algorithm not supported!>";
        }
        if (!this.issuerUniqueIDTag_.isOptional()) {
            res = res + "\n(V2)issuer unique ID:" + this.issuerUniqueID_.toString();
        }
        if (!this.subjectUniqueIDTag_.isOptional()) {
            res = res + "\n(V2)subject unique ID:" + this.subjectUniqueID_.toString();
        }
        if (!this.extensionsTag_.isOptional() && !this.extensions_.isEmpty()) {
            res = res + "\n(V3)extensions (" + this.extensions_.size() + ")\n";
            Iterator it = ((AbstractList)this.extensions_).iterator();
            int j = 1;
            while (it.hasNext()) {
                res = res + " " + String.valueOf(j++) + ":";
                try {
                    X509Extension mye = (X509Extension)it.next();
                    res = res + mye.toString(" ") + "\n";
                }
                catch (Exception e) {
                    res = res + " not handled:" + e.getMessage() + "\n";
                }
            }
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

