/*
 * Decompiled with CFR 0.152.
 */
package codec.x509;

import codec.CorruptedCodeException;
import codec.InconsistentStateException;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1Opaque;
import codec.asn1.ASN1Sequence;
import codec.asn1.ASN1Type;
import codec.asn1.DEREncoder;
import codec.pkcs8.PrivateKeyInfo;
import codec.util.JCA;
import codec.x509.SubjectPublicKeyInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class AlgorithmIdentifier
extends ASN1Sequence {
    protected ASN1Opaque parameters_;
    protected ASN1ObjectIdentifier algorithm_;

    public static AlgorithmIdentifier createAlgorithmIdentifier(Key key) throws CorruptedCodeException {
        try {
            if (key instanceof PublicKey) {
                return new SubjectPublicKeyInfo((PublicKey)key).getAlgorithmIdentifier();
            }
            if (key instanceof PrivateKey) {
                return new PrivateKeyInfo((PrivateKey)key).getAlgorithmIdentifier();
            }
            throw new IllegalArgumentException("Key type not supported!");
        }
        catch (InvalidKeyException e) {
            throw new CorruptedCodeException("Error decoding key!");
        }
    }

    public AlgorithmIdentifier() {
        super(2);
        this.algorithm_ = new ASN1ObjectIdentifier();
        this.parameters_ = new ASN1Opaque();
        this.parameters_.setOptional(true);
        this.add(this.algorithm_);
        this.add(this.parameters_);
    }

    public AlgorithmIdentifier(String algorithm) throws NoSuchAlgorithmException {
        super(2);
        if (algorithm == null) {
            throw new NullPointerException("Need an algorithm name!");
        }
        String oid = JCA.getOID(algorithm);
        if (oid == null) {
            throw new NoSuchAlgorithmException("No OID alias for algorithm " + algorithm);
        }
        try {
            this.algorithm_ = new ASN1ObjectIdentifier(oid);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchAlgorithmException("Bad OID alias for algorithm " + algorithm);
        }
        this.parameters_ = new ASN1Opaque(5, 0, new byte[0]);
        this.add(this.algorithm_);
        this.add(this.parameters_);
    }

    public AlgorithmIdentifier(ASN1ObjectIdentifier oid, byte[] b) throws ASN1Exception {
        super(2);
        if (oid == null) {
            throw new NullPointerException("Need an OID!");
        }
        this.algorithm_ = (ASN1ObjectIdentifier)oid.clone();
        this.parameters_ = b == null ? new ASN1Opaque(5, 0, new byte[0]) : new ASN1Opaque(b);
        this.add(this.algorithm_);
        this.add(this.parameters_);
    }

    public AlgorithmIdentifier(String alg, AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        super(2);
        if (alg == null) {
            throw new NullPointerException("Algorithm is null!");
        }
        String s = JCA.getOID(alg);
        if (s == null) {
            s = "1.3.14.3.2.7";
        }
        try {
            this.algorithm_ = new ASN1ObjectIdentifier(s);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAlgorithmParameterException("Bad OID alias for algorithm " + params.getAlgorithm());
        }
        try {
            this.parameters_ = params == null ? new ASN1Opaque(5, 0, new byte[0]) : new ASN1Opaque(params.getEncoded());
        }
        catch (IOException e) {
            throw new InvalidAlgorithmParameterException("Error during parameter encoding!");
        }
        catch (ASN1Exception e) {
            throw new InvalidAlgorithmParameterException("Parameter encoding is not ASN.1/DER!");
        }
        this.add(this.algorithm_);
        this.add(this.parameters_);
    }

    public AlgorithmIdentifier(ASN1ObjectIdentifier oid, ASN1Type params) throws ASN1Exception {
        super(2);
        if (oid == null) {
            throw new NullPointerException("Need an OID!");
        }
        this.algorithm_ = (ASN1ObjectIdentifier)oid.clone();
        try {
            if (params == null || params instanceof ASN1Null) {
                this.parameters_ = new ASN1Opaque(5, 0, new byte[0]);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DEREncoder enc = new DEREncoder(bos);
                params.encode(enc);
                this.parameters_ = new ASN1Opaque(bos.toByteArray());
                bos.close();
            }
            this.add(this.algorithm_);
            this.add(this.parameters_);
        }
        catch (IOException e) {
            throw new InconsistentStateException("Internal, caught IOException!");
        }
    }

    public AlgorithmParameters getParameters() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.parameters_.isOptional()) {
            return null;
        }
        if (this.parameters_.getTag() == 5 && this.parameters_.getTagClass() == 0) {
            return null;
        }
        String s = JCA.getName(this.algorithm_.toString());
        if (s == null) {
            throw new NoSuchAlgorithmException("Cannot resolve " + this.algorithm_.toString());
        }
        int n = s.indexOf("/");
        if (n > 0) {
            s = s.substring(0, n);
        }
        AlgorithmParameters params = AlgorithmParameters.getInstance(s);
        try {
            params.init(this.parameters_.getEncoded());
        }
        catch (IOException e) {
            throw new InvalidAlgorithmParameterException("Caught IOException(\"" + e.getMessage() + "\")");
        }
        catch (ASN1Exception e) {
            throw new InvalidAlgorithmParameterException("Caught ASN1Exception(\"" + e.getMessage() + "\")");
        }
        return params;
    }

    public ASN1ObjectIdentifier getAlgorithmOID() {
        return this.algorithm_;
    }

    public String getAlgorithmName() {
        return JCA.getName(this.algorithm_.toString());
    }

    public String toString() {
        String t = "X.509 AlgorithmIdentifier " + this.algorithm_.toString();
        String s = this.getAlgorithmName();
        if (s != null) {
            return t + " (" + s + ")";
        }
        return t;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AlgorithmIdentifier)) {
            return false;
        }
        return this.algorithm_.equals(((AlgorithmIdentifier)o).getAlgorithmOID());
    }

    public int hashCode() {
        return this.algorithm_.hashCode();
    }

    public Object clone() {
        AlgorithmIdentifier aid = (AlgorithmIdentifier)super.clone();
        aid.clear();
        aid.algorithm_ = (ASN1ObjectIdentifier)this.algorithm_.clone();
        aid.parameters_ = (ASN1Opaque)this.parameters_.clone();
        aid.add(this.algorithm_);
        aid.add(this.parameters_);
        return aid;
    }
}

