/*
 * Decompiled with CFR 0.152.
 */
package codec.util;

import codec.util.CertificateIterator;
import codec.util.CertificateSource;
import codec.x501.BadNameException;
import codec.x501.Name;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CertificateStore
implements CertificateSource {
    protected Map sdnIdx_ = new HashMap();
    protected Map isnIdx_ = new HashMap();

    public CertificateStore(KeyStore keystore) throws KeyStoreException {
        this.init(keystore);
    }

    public CertificateStore(Collection c) {
        this.init(c);
    }

    protected void init(KeyStore keystore) throws KeyStoreException {
        if (keystore == null) {
            throw new NullPointerException("KeyStore");
        }
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            String alias = e.nextElement();
            try {
                this.addCert((X509Certificate)keystore.getCertificate(alias));
            }
            catch (ClassCastException ex) {
                // empty catch block
            }
        }
    }

    protected void init(Collection c) {
        if (c == null) {
            throw new NullPointerException("Collection");
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            try {
                this.addCert((X509Certificate)i.next());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void addCert(X509Certificate cert) {
        if (cert == null) {
            return;
        }
        IdxKey entry = new IdxKey(cert.getSubjectDN());
        Object obj = this.sdnIdx_.get(entry);
        if (obj != null) {
            ArrayList<X509Certificate> list;
            if (obj instanceof List) {
                list = (ArrayList<X509Certificate>)obj;
            } else {
                list = new ArrayList<X509Certificate>(3);
                list.add((X509Certificate)obj);
                this.sdnIdx_.put(entry, list);
            }
            list.add(cert);
        } else {
            this.sdnIdx_.put(entry, cert);
        }
        entry = new IdxKey(cert.getIssuerDN(), cert.getSerialNumber());
        this.isnIdx_.put(entry, cert);
    }

    public X509Certificate getCertificate(Principal issuer, BigInteger serial) {
        return (X509Certificate)this.isnIdx_.get(new IdxKey(issuer, serial));
    }

    public Iterator certificates(Principal subject) {
        return this.certificates(subject, 0);
    }

    public Iterator certificates(Principal subject, int keyUsage) {
        ArrayList list;
        Object obj = this.sdnIdx_.get(new IdxKey(subject));
        if (obj == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (obj instanceof X509Certificate) {
            list = new ArrayList(1);
            list.add(obj);
        } else {
            list = (ArrayList)obj;
        }
        return new CertificateIterator(subject, keyUsage, list.iterator());
    }

    public class IdxKey {
        protected BigInteger serial_;
        protected String issuer_;
        protected String subject_;

        public IdxKey(Principal issuer, BigInteger serial) {
            try {
                Name name = new Name(issuer.getName(), -1);
                this.issuer_ = name.toString();
            }
            catch (BadNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            this.serial_ = serial;
        }

        public IdxKey(Principal subject) {
            try {
                Name name = new Name(subject.getName(), -1);
                this.subject_ = name.toString();
            }
            catch (BadNameException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof IdxKey)) {
                return false;
            }
            IdxKey e = (IdxKey)o;
            if (this.issuer_ != null || e.issuer_ != null) {
                if (this.issuer_ == null || e.issuer_ == null) {
                    return false;
                }
                if (!this.issuer_.equals(e.issuer_)) {
                    return false;
                }
            }
            if (this.subject_ != null || e.subject_ != null) {
                if (this.subject_ == null || e.subject_ == null) {
                    return false;
                }
                if (!this.subject_.equals(e.subject_)) {
                    return false;
                }
            }
            if (this.serial_ != null || e.serial_ != null) {
                if (this.serial_ == null || e.serial_ == null) {
                    return false;
                }
                if (!this.serial_.equals(e.serial_)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int h = 0;
            if (this.issuer_ != null) {
                h ^= this.issuer_.hashCode();
            }
            if (this.subject_ != null) {
                h ^= this.subject_.hashCode();
            }
            if (this.serial_ != null) {
                h ^= this.serial_.hashCode();
            }
            return h;
        }
    }
}

