/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Boolean;
import codec.asn1.ASN1Collection;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1Integer;
import codec.asn1.ASN1Null;
import codec.asn1.ASN1ObjectIdentifier;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1String;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Time;
import codec.asn1.ASN1Type;
import codec.asn1.Encoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class RunLengthEncoder
implements Encoder {
    public static final int INCREMENT = 256;
    private int[] stack_;
    private int tops_;
    private int[] acc_;
    private int topa_;

    public int[] getLengthFields() {
        if (this.tops_ == 0) {
            return new int[0];
        }
        int[] res = new int[this.tops_];
        System.arraycopy(this.stack_, 0, res, 0, this.tops_);
        return res;
    }

    public void writeType(ASN1Type o) throws ASN1Exception {
        try {
            o.encode(this);
        }
        catch (IOException e) {
            throw new ASN1Exception("Caught IOException without I/O!");
        }
    }

    public int getHeaderLength(int tag, int len) throws ASN1Exception {
        if (len < 0) {
            throw new ASN1Exception("Length is negative!");
        }
        int n = 2;
        if (tag > 30) {
            n += (this.significantBits(tag) + 6) / 7;
        }
        if (len > 127) {
            n += (this.significantBits(len) + 7) / 8;
        }
        return n;
    }

    protected int significantBits(int n) {
        if (n == 0) {
            return 1;
        }
        int i = 0;
        while (n > 255) {
            n >>>= 8;
            i += 8;
        }
        while (n > 0) {
            n >>>= 1;
            ++i;
        }
        return i;
    }

    public void writeBoolean(ASN1Boolean t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        this.push(t, 1);
    }

    public void writeInteger(ASN1Integer t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        int n = t.getBigInteger().bitLength() / 8 + 1;
        this.push(t, n);
    }

    public void writeBitString(ASN1BitString t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        int n = t.isZero() ? 1 : (t.bitCount() + 7) / 8 + 1;
        this.push(t, n);
    }

    public void writeOctetString(ASN1OctetString t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        this.push(t, t.byteCount());
    }

    public void writeNull(ASN1Null t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        this.push(t, 0);
    }

    public void writeObjectIdentifier(ASN1ObjectIdentifier t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        int[] e = t.getOID();
        if (e.length < 2) {
            throw new ASN1Exception("OID must have at least 2 elements!");
        }
        int n = 1;
        int i = 2;
        while (i < e.length) {
            n += (this.significantBits(e[i]) + 6) / 7;
            ++i;
        }
        this.push(t, n);
    }

    public void writeReal(ASN1Type t) {
        throw new UnsupportedOperationException("Real is not yet supported!");
    }

    public void writeString(ASN1String t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        this.push(t, t.convertedLength(t.getString()));
    }

    public void writeCollection(ASN1Collection t) throws ASN1Exception {
        ArrayList l;
        if (t.isOptional()) {
            return;
        }
        Collection c = t.getCollection();
        if (c instanceof ArrayList) {
            l = (ArrayList)c;
        } else {
            l = new ArrayList(c.size());
            l.addAll(c);
        }
        try {
            int p = this.sp();
            int i = l.size() - 1;
            while (i >= 0) {
                this.writeType((ASN1Type)l.get(i));
                --i;
            }
            int n = this.accumulate(p);
            this.push(t, n);
        }
        catch (ClassCastException e) {
            throw new ASN1Exception("Non-ASN.1 type in collection!");
        }
    }

    public void writeCollectionOf(ASN1Collection t) throws ASN1Exception {
        this.writeCollection(t);
    }

    public void writeTime(ASN1Time t) throws ASN1Exception {
        this.writeString(t);
    }

    public void writeTaggedType(ASN1TaggedType t) throws ASN1Exception {
        if (t.isOptional()) {
            return;
        }
        int p = this.sp();
        this.writeType(t.getInnerType());
        int n = this.accumulate(p);
        this.push(t, n);
    }

    public void writeTypeIdentifier(ASN1Type t) {
        throw new UnsupportedOperationException("TypeIdentifier is not yet supported!");
    }

    protected void reset() {
        this.tops_ = 0;
        this.topa_ = 0;
    }

    protected void push(ASN1Type t, int n) throws ASN1Exception {
        int[] stack;
        if (this.stack_ == null) {
            this.stack_ = new int[256];
            this.tops_ = 0;
        }
        if (this.tops_ == this.stack_.length) {
            stack = new int[this.stack_.length + 256];
            System.arraycopy(this.stack_, 0, stack, 0, this.stack_.length);
            this.stack_ = stack;
        }
        if (this.acc_ == null) {
            this.acc_ = new int[256];
            this.topa_ = 0;
        }
        if (this.topa_ == this.acc_.length) {
            stack = new int[this.acc_.length + 256];
            System.arraycopy(this.acc_, 0, stack, 0, this.acc_.length);
            this.acc_ = stack;
        }
        if (t.isExplicit()) {
            this.stack_[this.tops_++] = n;
            this.acc_[this.topa_++] = n + this.getHeaderLength(t.getTag(), n);
        } else {
            this.acc_[this.topa_++] = n;
        }
    }

    protected int sp() {
        return this.topa_;
    }

    protected int accumulate(int pos) {
        if (pos > this.topa_) {
            throw new IllegalStateException("Internal error, bad stack pointer!");
        }
        int n = 0;
        int i = pos;
        while (i < this.topa_) {
            n += this.acc_[i];
            ++i;
        }
        this.topa_ = pos;
        return n;
    }
}

