/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1BitString;
import codec.asn1.ASN1Collection;
import codec.asn1.ASN1CollectionOf;
import codec.asn1.ASN1Exception;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Opaque;
import codec.asn1.ASN1SequenceOf;
import codec.asn1.ASN1String;
import codec.asn1.ASN1TaggedType;
import codec.asn1.ASN1Type;
import codec.asn1.DERDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.Iterator;

public class BERDecoder
extends DERDecoder {
    static /* synthetic */ Class class$codec$asn1$ASN1BitString;
    static /* synthetic */ Class class$codec$asn1$ASN1OctetString;

    public BERDecoder(InputStream in) {
        super(in);
    }

    /*
     * WARNING - void declaration
     */
    protected void readTypes(ASN1Collection c) throws ASN1Exception, IOException {
        if (this.indefinite_) {
            ASN1Type o;
            while ((o = this.readType()) != null) {
                void var2_2;
                c.add(var2_2);
            }
        } else {
            super.readTypes(c);
        }
    }

    public void readBitString(ASN1BitString t) throws ASN1Exception, IOException {
        this.match1(t);
        this.skipNext(true);
        if (this.primitive_) {
            super.readBitString(t);
            return;
        }
        ASN1SequenceOf seq = new ASN1SequenceOf(class$codec$asn1$ASN1BitString == null ? (class$codec$asn1$ASN1BitString = BERDecoder.class$("codec.asn1.ASN1BitString")) : class$codec$asn1$ASN1BitString);
        this.tag_ = 16;
        this.tagclass_ = 0;
        seq.decode(this);
        int pad = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Iterator i = ((AbstractList)seq).iterator();
            while (i.hasNext()) {
                ASN1BitString v = (ASN1BitString)i.next();
                bos.write(v.getBytes());
                int n = pad;
                pad = v.getPadCount();
                if (pad == 0 || n == 0) continue;
                throw new ASN1Exception("Pad count mismatch in BIT STRING segment!");
            }
            byte[] buf = bos.toByteArray();
            bos.close();
            t.setBits(buf, pad);
        }
        catch (ClassCastException e) {
            throw new ASN1Exception("Type mismatch in BER encoded BIT STRING segment!");
        }
    }

    public void readOctetString(ASN1OctetString t) throws ASN1Exception, IOException {
        byte[] buf;
        this.match1(t);
        this.skipNext(true);
        if (this.primitive_) {
            super.readOctetString(t);
            return;
        }
        ASN1SequenceOf seq = new ASN1SequenceOf(class$codec$asn1$ASN1OctetString == null ? (class$codec$asn1$ASN1OctetString = BERDecoder.class$("codec.asn1.ASN1OctetString")) : class$codec$asn1$ASN1OctetString);
        this.tag_ = 16;
        this.tagclass_ = 0;
        seq.decode(this);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            Iterator i = ((AbstractList)seq).iterator();
            while (i.hasNext()) {
                ASN1OctetString v = (ASN1OctetString)i.next();
                bos.write(v.getByteArray());
            }
            buf = bos.toByteArray();
            bos.close();
        }
        catch (ClassCastException e) {
            throw new ASN1Exception("Type mismatch in BER encoded OCTET STRING segment!");
        }
        t.setByteArray(buf);
    }

    public void readString(ASN1String t) throws ASN1Exception, IOException {
        this.match1(t);
        this.skipNext(true);
        if (this.primitive_) {
            super.readString(t);
            return;
        }
        ASN1OctetString v = new ASN1OctetString();
        this.tag_ = 4;
        this.tagclass_ = 0;
        v.decode(this);
        t.setString(t.convert(v.getByteArray()));
    }

    public void readCollection(ASN1Collection t) throws ASN1Exception, IOException {
        ASN1Type o;
        this.match0(t, false);
        int end = this.pos_ + this.length_;
        boolean vlen = this.indefinite_;
        Iterator i = t.iterator();
        int n = 0;
        while (i.hasNext()) {
            if (!this.readNext()) break;
            this.skipNext(true);
            o = (ASN1Type)i.next();
            ++n;
            if (o.isType(this.tag_, this.tagclass_)) {
                o.decode(this);
                o.setOptional(false);
                if (vlen) continue;
                if (this.pos_ == end) break;
                if (this.pos_ <= end) continue;
                throw new ASN1Exception("Length short by " + (this.pos_ - end) + " octets!");
            }
            if (o.isOptional()) continue;
            throw new ASN1Exception("ASN.1 type mismatch!\nExpected: " + o.getClass().getName() + "\nIn      : " + t.getClass().getName() + "\nAt index: " + (n - 1) + "\nGot tag : " + this.tag_ + " and class: " + this.tagclass_);
        }
        while (i.hasNext()) {
            o = (ASN1Type)i.next();
            ++n;
            if (o.isOptional()) continue;
            throw new ASN1Exception("ASN.1 type missing!\nExpected: " + o.getClass().getName() + "\nIn      : " + t.getClass().getName() + "\nAt index: " + (n - 1));
        }
        if (vlen) {
            this.match2(0, 0);
        } else if (this.pos_ < end) {
            throw new ASN1Exception("Bad length, " + (end - this.pos_) + " contents octets left!");
        }
    }

    public void readCollectionOf(ASN1CollectionOf t) throws ASN1Exception, IOException {
        this.match0(t, false);
        t.clear();
        boolean vlen = this.indefinite_;
        int end = this.pos_ + this.length_;
        while (true) {
            if (!vlen) {
                if (this.pos_ == end) {
                    return;
                }
                if (this.pos_ > end) {
                    throw new ASN1Exception("Read " + (this.pos_ - end) + " octets too much!");
                }
            }
            if (!this.readNext()) {
                if (vlen) {
                    throw new ASN1Exception("EOC missing at EOF!");
                }
                throw new ASN1Exception("Bad length!");
            }
            if (vlen && this.tag_ == 0 && this.tagclass_ == 0) {
                return;
            }
            try {
                this.skipNext(true);
                ASN1Type o = t.newElement();
                o.decode(this);
            }
            catch (IllegalStateException e) {
                throw new ASN1Exception("Cannot create new element! ");
            }
        }
    }

    public void readTaggedType(ASN1TaggedType t) throws ASN1Exception, IOException {
        this.match1(t);
        boolean vlen = this.indefinite_;
        ASN1Type o = t.getInnerType();
        if (o.isExplicit() && this.primitive_) {
            throw new ASN1Exception("PRIMITIVE vs. CONSTRUCTED mismatch!");
        }
        if (t instanceof ASN1Opaque) {
            if (vlen) {
                throw new ASN1Exception("Cannot decode indefinite length encodings with ASN1Opaque type!");
            }
            this.primitive_ = true;
        }
        o.decode(this);
        if (vlen && o.isExplicit()) {
            this.match2(0, 0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

