/*
 * Decompiled with CFR 0.152.
 */
package codec.asn1;

import codec.asn1.ASN1AbstractType;
import codec.asn1.ASN1Exception;
import codec.asn1.ConstraintException;
import codec.asn1.Decoder;
import codec.asn1.Encoder;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1AbstractType {
    private static int opi_;
    private BigInteger value_;

    public ASN1Integer() {
        this.value_ = BigInteger.ZERO;
    }

    public ASN1Integer(BigInteger val) {
        if (val == null) {
            throw new NullPointerException("Need a number!");
        }
        this.value_ = val;
    }

    public ASN1Integer(String val) throws NumberFormatException {
        this.value_ = new BigInteger(val);
    }

    public ASN1Integer(byte[] val) throws NumberFormatException {
        this.value_ = new BigInteger(val);
    }

    public ASN1Integer(int signum, byte[] magnitude) throws NumberFormatException {
        this.value_ = new BigInteger(signum, magnitude);
    }

    public ASN1Integer(int n) {
        byte[] b = new byte[opi_];
        int m = n;
        int i = opi_ - 1;
        while (i >= 0) {
            b[i] = (byte)(m & 0xFF);
            m >>>= 8;
            --i;
        }
        this.value_ = new BigInteger(b);
    }

    public Object getValue() {
        return this.value_;
    }

    public BigInteger getBigInteger() {
        return this.value_;
    }

    public void setBigInteger(BigInteger n) throws ConstraintException {
        this.value_ = n;
        this.checkConstraints();
    }

    public int getTag() {
        return 2;
    }

    public void encode(Encoder enc) throws ASN1Exception, IOException {
        enc.writeInteger(this);
    }

    public void decode(Decoder dec) throws ASN1Exception, IOException {
        dec.readInteger(this);
        this.checkConstraints();
    }

    public String toString() {
        return "Integer " + this.value_.toString();
    }

    static {
        int n = 1;
        int i = 0;
        while (n != 0) {
            ++i;
            n <<= 8;
        }
        opi_ = i;
    }
}

