/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.ICETransport;

import homemonitor.GDErrorCode;
import homemonitor.ICETransport.Candidates;
import homemonitor.ICETransport.ICETransportInterface;
import homemonitor.ICETransport.ICETransportReceiverInterface;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class IceTransportService
implements ICETransportReceiverInterface {
    private static Logger log = Logger.getLogger(IceTransportService.class);
    private ICETransportInterface iceTransport;
    private CountDownLatch latch;
    private Candidates foundCandidates = null;

    public IceTransportService(ICETransportInterface iceTransport) {
        this.iceTransport = iceTransport;
    }

    public Candidates execute(String deviceId, String stunAddr, Integer stunPort, String turnAddr, Integer turnPort, String turnUser, String turnPass, String candidates) {
        log.trace((Object)("start IceTransportService[" + this + "].execute(deviceId=" + deviceId + ", stunAddr=" + stunAddr + ", stunPort=" + stunPort + ", turnAddr=" + turnAddr + ", turnPort=" + turnPort + ", turnUser=" + turnUser + ", turnPass=" + turnPass + ", candidates=" + candidates + ")"));
        long sessionID = this.iceTransport.createSession(deviceId, this);
        if (sessionID == 0L) {
            log.debug((Object)("SearchCandidatesService.execute(" + deviceId + ") failed because device is not connected"));
            return null;
        }
        this.foundCandidates = null;
        this.latch = new CountDownLatch(1);
        GDErrorCode errorCode = this.iceTransport.send(sessionID, stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        if (errorCode != GDErrorCode.NoError) {
            log.error((Object)("Failed to search for candidates for deviceId=" + deviceId + ", stunAddr=" + stunAddr + ", stunPort=" + stunPort + ", turnAddr=" + turnAddr + ", turnPort=" + turnPort + ", turnUser=" + turnUser + ", turnPass=" + turnPass + ", candidates=" + candidates + " cause: " + (Object)((Object)errorCode)));
            return null;
        }
        try {
            this.latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.debug((Object)("end searchCandidates: " + this.foundCandidates));
        return this.foundCandidates;
    }

    @Override
    public void received(int startPort, int endPort, String candidates) {
        if (candidates != null) {
            this.foundCandidates = new Candidates();
            this.foundCandidates.setPortRangeStart(startPort);
            this.foundCandidates.setPortRangeEnd(endPort);
            this.foundCandidates.setCandidates(candidates);
        } else {
            this.foundCandidates = null;
        }
        this.latch.countDown();
    }

    @Override
    public void deviceDisconnected() {
        this.foundCandidates = null;
        this.latch.countDown();
    }
}

