/*
 * Decompiled with CFR 0.152.
 */
package homemonitor;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BlockPeriodCache {
    private static final int BLOCK_INDEFINITE = 0;
    private static final int MIN_BLOCK_PERIOD = 5;
    private static Logger log = Logger.getLogger(BlockPeriodCache.class);
    private int[] blockPeriod;

    @Value(value="${security.blockPeriod}")
    public void setBlockPeriod(String period) {
        period = period.trim();
        String[] parts = period.split(",");
        this.blockPeriod = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.blockPeriod[i] = Integer.valueOf(parts[i]);
            if (this.blockPeriod[i] == 0 || this.blockPeriod[i] >= 5) continue;
            throw new RuntimeException(String.format("security.blockPeriod cannot be less than %d!", 5));
        }
    }

    public Long getBlockPeriod(Integer blockCount, Unit unit) {
        log.trace((Object)("start getBlockPeriod(blockCount=" + blockCount + ")"));
        if (blockCount == null) {
            throw new NullPointerException("blockCount");
        }
        if (blockCount < 1) {
            return null;
        }
        int blockPeriodIndex = Math.min(blockCount, this.blockPeriod.length) - 1;
        return (long)this.blockPeriod[blockPeriodIndex] * unit.multiplier();
    }

    public String toString() {
        return "BlockPeriodCache [blockPeriod=" + Arrays.toString(this.blockPeriod) + "]";
    }

    public static enum Unit {
        MINUTE(1L),
        SECOND(60L),
        MILLISECOND(60000L);

        private long multiplier;

        private Unit(long multiplier) {
            this.multiplier = multiplier;
        }

        public long multiplier() {
            return this.multiplier;
        }
    }
}

