/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.util;

import com.hazelcast.core.HazelcastInstance;
import com.vestiacom.util.SharedCache;
import com.vestiacom.util.SharedCacheException;
import com.vestiacom.util.SharedCacheInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SharedCacheHazelcast
implements SharedCache {
    private HazelcastInstance hazelcast;
    private Set<String> cacheNames = new HashSet<String>();

    @Autowired
    @Required
    public void setHazelcast(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getMap(String cacheName, SharedCache.Flag ... flags) {
        this.cacheNames.add(cacheName);
        return this.hazelcast.getMap(cacheName);
    }

    @Override
    public Integer countEntries(String cacheName) {
        this.validateCacheName(cacheName);
        return this.getMap(cacheName, new SharedCache.Flag[0]).size();
    }

    private void validateCacheName(String cacheName) {
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            throw new SharedCacheException(SharedCacheException.ErrorCode.NO_CACHE_NAME);
        }
        if (!this.cacheNames.contains(cacheName)) {
            throw new SharedCacheException(SharedCacheException.ErrorCode.CACHE_NOT_FOUND);
        }
    }

    @Override
    public Set<Object> listKeys(String cacheName) {
        this.validateCacheName(cacheName);
        return this.getMap(cacheName, new SharedCache.Flag[0]).keySet();
    }

    @Override
    public SharedCacheInfo getInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

