/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service.impl;

import com.vestiacom.gdserver.connector.AppServerConnector;
import com.vestiacom.gdserver.rest.model.Message;
import com.vestiacom.gdserver.service.RestProxyException;
import com.vestiacom.gdserver.service.RestProxyService;
import homemonitor.GatewayDeviceConnection;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="singleton")
public class RestProxyServiceImpl
implements RestProxyService {
    private static Logger log = Logger.getLogger(RestProxyServiceImpl.class);
    private AppServerConnector appServerConnector;
    private String restUrl;
    private Map<String, RestProxy> proxies = new ConcurrentHashMap<String, RestProxy>();

    @Autowired
    @Required
    public void setAppServerConnector(AppServerConnector appServerConnector) {
        this.appServerConnector = appServerConnector;
    }

    @Autowired
    @Required
    @Value(value="${GDConnection.restUrl}")
    public void setServerUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    @Override
    public void sendRequest(String mac, short id, String path, GatewayDeviceConnection gatewayDeviceConnection) {
        Message message = new Message(Message.Type.REST_PROXY_REQUEST, mac);
        message.setParam(Message.Param.REST_PROXY_ID, new Short(id).toString());
        message.setParam(Message.Param.REST_PROXY_PATH, path);
        message.setParam(Message.Param.SOURCE_SERVER, this.restUrl);
        log.debug((Object)("Registering REST proxy with key: " + this.getProxyKey(mac, id)));
        this.proxies.put(this.getProxyKey(mac, id), new RestProxy(mac, id, gatewayDeviceConnection));
        this.appServerConnector.addMessage(message);
    }

    private String getProxyKey(String mac, short id) {
        return mac + "/" + id;
    }

    protected void sendResponse(RestProxy restProxy, String response) {
        byte[] responseArray = null;
        if (response != null) {
            responseArray = response.getBytes();
        }
        ByteBuffer buffer = ByteBuffer.allocate(4 + (responseArray != null ? responseArray.length : 0));
        buffer.putShort(restProxy.id);
        if (response != null) {
            buffer.put(responseArray);
        }
        restProxy.gatewayDeviceConnection.sendSimple(23, restProxy.mac, buffer.array());
    }

    @Override
    public void handleResponse(String mac, Short id, String data) throws RestProxyException {
        try {
            log.debug((Object)("Handling REST proxy with key: " + this.getProxyKey(mac, id)));
            RestProxy restProxy = this.proxies.remove(this.getProxyKey(mac, id));
            this.sendResponse(restProxy, data);
        }
        catch (Exception e) {
            throw new RestProxyException("Cannot handle REST proxy response for device " + mac + ", id " + id + ": " + e.getMessage());
        }
    }

    private class RestProxy {
        private String mac;
        private short id;
        private GatewayDeviceConnection gatewayDeviceConnection;

        public RestProxy(String mac, short id, GatewayDeviceConnection gatewayDeviceConnection) {
            this.mac = mac;
            this.id = id;
            this.gatewayDeviceConnection = gatewayDeviceConnection;
        }
    }
}

