/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.service;

import com.vestiacom.gdserver.rest.model.HttpCommand;
import homemonitor.HTTPClient.HTTPClientService;
import homemonitor.TCPProxy.TCPProxy;
import homemonitor.tcpclient.TCPClient;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HTTPClientServiceFactory {
    private static Logger log = Logger.getLogger(HTTPClientServiceFactory.class);
    private TCPProxy tcpProxy;
    private TCPClient tcpClient;
    private Integer httpClientServiceTimeout;

    @Autowired
    @Required
    public void setTcpProxy(TCPProxy tcpProxy) {
        this.tcpProxy = tcpProxy;
    }

    @Autowired
    @Required
    public void setTcpClient(TCPClient tcpClient) {
        this.tcpClient = tcpClient;
    }

    @Value(value="${httpClientService.timeout}")
    public void setHttpClientServiceTimeout(Integer httpClientServiceTimeout) {
        this.httpClientServiceTimeout = httpClientServiceTimeout;
    }

    public HTTPClientService getInstance(HttpCommand.ConnectionType connectionType) {
        return this.getInstance(connectionType, null);
    }

    public HTTPClientService getInstance(HttpCommand.ConnectionType connectionType, Integer timeout) {
        HTTPClientService httpClientService = null;
        if (timeout == null) {
            timeout = this.httpClientServiceTimeout;
        }
        if (connectionType == HttpCommand.ConnectionType.TCP_CLIENT) {
            httpClientService = new HTTPClientService(this.tcpClient);
        } else if (connectionType == HttpCommand.ConnectionType.TCP_PROXY) {
            httpClientService = new HTTPClientService(this.tcpProxy);
        } else {
            log.error((Object)("Unsupported connection type: " + (Object)((Object)connectionType) + "."));
            return null;
        }
        httpClientService.setTimeout(timeout.intValue());
        return httpClientService;
    }
}

