/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.rest.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class BatchMessage {
    private String mac;
    private Type type;
    private long timestamp = System.currentTimeMillis();
    private HashMap<Param, String> params = new HashMap();

    public BatchMessage() {
    }

    public BatchMessage(Type type, String mac) {
        this.type = type;
        this.mac = mac;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setParam(Param key, String value) {
        this.params.put(key, value);
    }

    public String getParam(Param param) {
        return this.params.get((Object)param);
    }

    public String toString() {
        return "Message [mac=" + this.mac + ", type=" + (Object)((Object)this.type) + ", timestamp=" + BatchMessage.formatDate(this.timestamp, "yyyy-MM-dd HH:mm:ss") + "]";
    }

    public String dump() {
        return "Message [mac=" + this.mac + ", type=" + (Object)((Object)this.type) + ", timestamp=" + BatchMessage.formatDate(this.timestamp, "yyyy-MM-dd HH:mm:ss") + ", params=" + this.params + "]";
    }

    public static String formatDate(long date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(new Date(date));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BatchMessage other = (BatchMessage)obj;
        if (this.mac == null ? other.mac != null : !this.mac.equals(other.mac)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum Param {
        NAME,
        ADDRESS_TYPE,
        PORT,
        VALUE,
        REST_PROXY_ID,
        REST_PROXY_RESPONSE_BODY;

    }

    public static enum Type {
        REGISTERED,
        DOMAIN_NAME,
        SET_UP_UPNP,
        REST_PROXY_RESPONSE;

    }
}

