/**
  ******************************************************************************
  * @file    backlight_control.h
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    07/07/2010
  * @brief   This file contains exported variables and protoypes for 
  *          backlight_control.c.            
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2010 STMicroelectronics</center></h2>
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BACKLIGHT_CONTROL_H
#define __BACKLIGHT_CONTROL_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x.h"


/** @addtogroup STM32F10x_LCD_Drive
  * @{
  */

/** @addtogroup BACKLIGHT_CONTROL
  * @{
  */  


/** @defgroup BACKLIGHT_CONTROL_Exported_Constants
  * @{
  */ 

#define LCD_BL_GPIO_PORT_CLOCK       RCC_APB2Periph_GPIOB
#define LCD_BL_GPIO_PIN              GPIO_Pin_6
#define LCD_BL_GPIO_PORT             GPIOB

#define LCD_BLCTRL_GPIO_PORT_CLOCK   RCC_APB2Periph_GPIOC
#define LCD_BLCTRL_GPIO_PIN          GPIO_Pin_4
#define LCD_BLCTRL_GPIO_PORT         GPIOC

#define LCD_BL_TIMER_PERIOD         (uint16_t) 8999

/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Exported_Variables
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup BACKLIGHT_CONTROL_Exported_Functions
  * @{
  */ 

void LCD_BacklightConfiguration(void);

/**
  * @}
  */ 

#endif /*__BACKLIGHT_CONTROL_H*/

/**
  * @}
  */ 

/**
  * @}
  */ 
/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
