/*
 * Copyright (c) 2012 SoftAtHome
 *
 * The information and source code contained herein is the exclusive
 * property of SoftAtHome and may not be disclosed, examined, or
 * reproduced in whole or in part without explicit written authorization
 * of the copyright owner.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <debug/sahtrace.h>

#include <pcb/utils.h>
#include <pcb/core.h>

#include <mtk.h>

#define ME "simple"

static pcb_timer_t *simple_timer;

static void simple_tick(pcb_timer_t *timer __attribute__((unused)), void *userdata __attribute__((unused))) {
    SAH_TRACEZ_INFO(ME, "=> Timer tick");
    printf("Simple timer tick\n");
}

static bool simple_start(argument_value_list_t *args) {
    SAH_TRACEZ_INFO(ME, "Starting ...");
    printf("\n");

    uint32_t interval;
    // take the argument "interval" from the argument list, if not available use 5 as a default value
    argument_getUInt32(&interval, args, request_function_args_by_name, "interval", 5);
    // create the timer
    simple_timer = pcb_timer_create();
    // set the timeout handler, this function is called when the timer expires
    pcb_timer_setHandler(simple_timer, simple_tick);
    // set the repeat interval
    pcb_timer_setInterval(simple_timer, interval * 1000);
    // start the timer, use the same timeout the first time as the timer interval
    pcb_timer_start(simple_timer, 1);
    // all done - module initialized and started
    SAH_TRACEZ_INFO(ME, "Started");
    return true;
}

static void simple_stop() {
    SAH_TRACEZ_INFO(ME, "Stopping ...");
    pcb_timer_destroy(simple_timer);
    SAH_TRACEZ_INFO(ME, "Stopped");
}

static mtk_module_info_t simple_info = {
    .name = ME,
    .start = simple_start,
    .stop = simple_stop
};

__attribute__((constructor)) static void simple_init() {
    mtk_module_register(&simple_info);
}
