/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#include <stdlib.h>

#include <debug/sahtrace.h>
#include <pcb/core.h>

plugin_config_t *cfg = NULL;

static bool test_item_handler(request_t * req, reply_item_t * item, pcb_t * pcb, peer_info_t * from, void * userdata) {
    (void)req;
    (void)item;
    (void)pcb;
    (void)from;
    (void)userdata;

    SAH_TRACE_NOTICE("===================================== RECIEVED REPLY ==================================");
    SAH_TRACE_NOTICE("REPLY request id = 0x%x", request_id(req));
    SAH_TRACE_NOTICE("===================================== RECIEVED REPLY ==================================");

    return true;
}

static bool test_done_handler(request_t *req, pcb_t *pcb, peer_info_t *from, void *userdata) {
    (void)req;
    (void)pcb;
    (void)from;
    (void)userdata;

    SAH_TRACE_NOTICE("===================================== REQUEST DONE ==================================");
    SAH_TRACE_NOTICE("DONE request id = 0x%x", request_id(req));
    SAH_TRACE_NOTICE("===================================== REQUEST DONE ==================================");


    request_destroy(req);
    return true;
}

bool pcb_plugin_initialize(pcb_t __attribute__((unused)) *pcb,
                           int __attribute__((unused)) argc,
                           char __attribute__((unused)) *argv[]) {
    SAH_TRACE_INFO("Starting plugin");

    cfg = pcb_pluginConfig(pcb);

    // No extra initialization needed
    return true;
}

void pcb_plugin_cleanup() {
    SAH_TRACE_INFO("Stopping plugin");

    // No extra cleanup is needed
    return;
}

function_exec_state_t __sayHello(function_call_t *fcall, argument_value_list_t *args, variant_t *retval) {
    uint32_t attr = request_attributes(fcall_request(fcall));

    char *name = NULL;

    // take arguments out of the argument list
    argument_getChar(&name, args, attr, "name", "World");

    // clear the arghument list in case the caller has added arguments
    // if the argument list is not cleared, all arguments will be sent back as out arguments
    argument_valueClear(args);

    // print the greeting message
    printf("\nHello %s\n", name);

    // cleanup data
    free(name);

    // end the RPC call
    variant_initialize(retval, variant_type_unknown); // the unknown type is used for the void return value
    return function_exec_done;
}

function_exec_state_t __runTest(function_call_t *fcall, argument_value_list_t *args, variant_t *retval) {
    (void)fcall;
    (void)args;

    request_t * request = request_create_getObject("MultiInstance.1", -1, request_common_path_key_notation
                                                                        | request_getObject_all
                                                                        | request_no_object_caching);
    if (request) {
        request_setReplyItemHandler(request, test_item_handler);
        request_setDoneHandler(request, test_done_handler);
        pcb_sendRequest(cfg->pcb, cfg->system_bus, request);
        SAH_TRACE_NOTICE("================== SENDING REQUEST ================================");
        SAH_TRACE_NOTICE("request id = 0x%x", request_id(request));
        SAH_TRACE_NOTICE("================== SENDING REQUEST ================================");
    }

    // end the RPC call
    variant_initialize(retval, variant_type_unknown); // the unknown type is used for the void return value
    return function_exec_done;
}
