/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/
/**
 * @file usermngt/usermngt.h
 */
#ifndef USERMNGT_USERMNGT_H
#define USERMNGT_USERMNGT_H

#include <stdbool.h>
#include <stdint.h>
#include <components.h>

#define USERMNGT_USERNAME_LENGTH 64
#define USERMNGT_GROUPNAME_LENGTH 64
#define USERMNGT_PASSWORD_LENGTH 64
#define USERMNGT_SALT_LENGTH 64
#define USERMNGT_USER_GROUP_LENGTH CONFIG_SAH_LIB_USERMNGT_GROUPS_COUNT
#define USERMNGT_USERS_LENGTH CONFIG_SAH_LIB_USERMNGT_USERS_COUNT
#define USERMNGT_GROUPS_LENGTH CONFIG_SAH_LIB_USERMNGT_GROUPS_COUNT
#define USERMNGT_PASSWD_FILE CONFIG_SAH_LIB_USERMNGT_PASSWD_FILE

#ifdef __cplusplus
extern "C" {
#endif

typedef enum usermngt_passwordType {
  USERMNGT_PASSWD_UNKNOWN,
  USERMNGT_PASSWD_MD5,
  USERMNGT_PASSWD_SSHA256
} usermngt_passwordType_t;

typedef struct usermngt_group {
  uint32_t gid;
  bool enable;
  char name[USERMNGT_GROUPNAME_LENGTH + 1];
} usermngt_group_t;

typedef struct usermngt_user {
  uint32_t uid;
  bool enable;
  char name[USERMNGT_USERNAME_LENGTH + 1];
  usermngt_passwordType_t passwordType;
  char password[USERMNGT_PASSWORD_LENGTH + 1];
  char salt[USERMNGT_SALT_LENGTH + 1];
  uint8_t groupCount;
  usermngt_group_t groups[USERMNGT_USER_GROUP_LENGTH + 1];
} usermngt_user_t;

typedef struct usermngt_model {
  uint8_t userCount;
  usermngt_user_t users[USERMNGT_USERS_LENGTH];
  uint8_t groupCount;
  usermngt_group_t groups[USERMNGT_GROUPS_LENGTH];
} usermngt_model_t;

static inline uint32_t usermngt_userID(const usermngt_user_t *user) 
{
  return user->uid;
}

static inline uint32_t usermngt_userEnable(const usermngt_user_t *user) 
{
  return user->enable;
}

static inline const char *usermngt_userName(const usermngt_user_t *user) 
{
  return user->name;
}

static inline uint32_t usermngt_groupID(const usermngt_group_t *group) 
{
  return group->gid;
}

static inline uint32_t usermngt_groupEnable(const usermngt_group_t *group) 
{
  return group->enable;
}

static inline const char *usermngt_groupName(const usermngt_group_t *group) 
{
  return group->name;
}

int usermngt_usercmp(const void *user1, const void *user2);
int usermngt_groupcmp(const void *group1, const void *group2);
const usermngt_user_t *usermngt_userFindByName(const char *user);
const usermngt_user_t *usermngt_userFindByID(uint32_t uid);
const usermngt_user_t *usermngt_userFirst();
const usermngt_user_t *usermngt_userNext();
const usermngt_group_t *usermngt_userGroupFirst(const usermngt_user_t *user);
const usermngt_group_t *usermngt_userGroupNext(const usermngt_user_t *user);
const usermngt_group_t *usermngt_userGroupFindByName(const usermngt_user_t *user, const char *name);
const usermngt_group_t *usermngt_userGroupFindByID(const usermngt_user_t *user, uint32_t gid);
const usermngt_group_t *usermngt_groupFindByName(const char *user);
const usermngt_group_t *usermngt_groupFindByID(uint32_t gid);
const usermngt_group_t *usermngt_groupFirst();
const usermngt_group_t *usermngt_groupNext();

#define usermngt_user_for_each_group(group, user) \
    for (group = usermngt_userGroupFirst(user); group; group = usermngt_userGroupNext(user))

#if __STDC_VERSION__ >= 199901L
#define usermngt_user_for_each_declare_group(group, user) \
    for (const usermngt_group_t *group = usermngt_userGroupFirst(user); group; group = usermngt_userGroupNext(user))

#endif


/**
 * Check if a user belongs to a group
 *
 * @param user the user that might belong to the group
 * @param gid the unique id of the group that might contains the user
 * @return true if the user is in the group
 */
static inline bool usermngt_userIsInGroup(const usermngt_user_t *user, uint32_t gid)
{
  return (usermngt_userGroupFindByID(user, gid) != (void *) 0);
}

#define SAH_USERMNGT_SALTLENGTH 65
#define SAH_USERMNGT_HASHLENGTH 65

bool usermngt_hashPassword(const char *type, const char *password, const char *salt, char hashed[SAH_USERMNGT_HASHLENGTH]);
bool usermngt_generateSalt(char salt[SAH_USERMNGT_SALTLENGTH]);

#ifdef __cplusplus
}
#endif


#endif
