/****************************************************************************
**
** Copyright (C) 2011 SoftAtHome. All rights reserved.
**
** SoftAtHome reserves all rights not expressly granted herein.
**
** - DISCLAIMER OF WARRANTY -
**
** THIS FILE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
** EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO, THE IMPLIED
** WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
** PURPOSE.
**
** THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOURCE
** CODE IS WITH YOU. SHOULD THE SOURCE CODE PROVE DEFECTIVE, YOU
** ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
**
** - LIMITATION OF LIABILITY -
**
** IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
** WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MODIFIES
** AND/OR DISTRIBUTES THE SOURCE CODE, BE LIABLE TO YOU FOR DAMAGES,
** INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES
** ARISING OUT OF THE USE OR INABILITY TO USE THE SOURCE CODE
** (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED
** INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE
** OF THE SOURCE CODE TO OPERATE WITH ANY OTHER PROGRAM), EVEN IF SUCH
** HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
** DAMAGES.
**
****************************************************************************/

#ifndef _PCB_CLIENT_H_
#define _PCB_CLIENT_H_

#include <pcb/common.h>
#include <pcb/utils.h>
#include <pcb/core.h>

#ifdef __cplusplus
extern "C"
{
#endif

typedef bool (* pcb_client_object_callback)(object_t *object, void *userdata);

typedef enum _pcb_client_attribute {
    pcb_client_attr_default         = 0,  // boolean, reset to defaults if true
    pcb_client_attr_key_notation,         // boolean, set key notation on(true)/off(false)
    pcb_client_attr_slash_seperator,      // boolean, set slash seperator on(true)/off(false)
    pcb_client_attr_timeout,              // integer; set the timeout time in ms, default = 5000
    pcb_client_attr_untrusted,            // boolean: All request done using the pcb context will be handled as untrusted
    pcb_client_attr_alias_notation,       // boolean, set alias notation on(true)/off(false)
} pcb_client_attribute_t;

typedef struct _pcb_client_error {
    uint32_t error;
    char *info;
    llist_iterator_t it;
} pcb_client_error_t;

bool             pcb_client_set_attribute(pcb_t *client, pcb_client_attribute_t attrib, uint32_t value);
bool             pcb_client_set_user(pcb_t *client, const char *username);
uint32_t         pcb_client_get_path_attributes(pcb_t *client);
uint32_t         pcb_client_error(pcb_t *client);
const llist_t   *pcb_client_errors(pcb_t *client);
void             pcb_client_clear_errors(pcb_t *client);

peer_info_t     *pcb_client_connect(pcb_t *client, const char *URI);

bool             pcb_client_set(peer_info_t *dest, const char *objectPath, const char *parameter, const variant_t *val);
bool             pcb_client_validate(peer_info_t *dest, const char *objectPath, const char *parameter, const variant_t *val);
const variant_t *pcb_client_get(peer_info_t *dest, const char *objectPath, const char *parameter);
parameter_t     *pcb_client_get_parameter(peer_info_t *dest, const char *objectPath, const char *parameter);

function_t      *pcb_client_get_function(peer_info_t *dest, const char *objectPath, const char *function);

bool             pcb_client_wait_for_object(peer_info_t *dest, const char *objectPath);
bool             pcb_client_set_object(peer_info_t *dest, const char *objectPath, variant_map_t *parameters);
bool             pcb_client_validate_object(peer_info_t *dest, const char *objectPath, variant_map_t *parameters);
object_t        *pcb_client_get_object(peer_info_t *dest, const char *objectPath);
bool             pcb_client_get_objects(peer_info_t *dest, const char *objectPath, pcb_client_object_callback fn, void *userdata);

object_t        *pcb_client_add_instance(peer_info_t *dest, const char *objectPath, uint32_t index, const char *key, variant_map_t *parameters);
bool             pcb_client_delete_instance(peer_info_t *dest, const char *objectPath);

#ifdef __cplusplus
}
#endif
#endif
