/*
 * Copyright (c) 2012 SoftAtHome
 *
 * The information and source code contained herein is the exclusive
 * property of SoftAtHome and may not be disclosed, examined, or
 * reproduced in whole or in part without explicit written authorization
 * of the copyright owner.
 *
 */
#ifndef __MTK_H__
#define __MTK_H__

#include <pcb/utils.h>
#include <pcb/core.h>

#ifdef __cplusplus
extern "C"
{
#endif

#define NOTIFY_MTK_RPC 110

#define MTK_ATTR_SYNC 0x01

typedef struct _mtk mtk_t;

typedef struct _mtk_so mtk_so_t;

typedef struct _mtk_module mtk_module_t;

typedef struct _mtk_rpc mtk_rpc_t;

typedef struct _request mtk_notification_t;

typedef struct _mtk_function_info {
    const char *name;
    bool (*cb)(mtk_rpc_t *rpc);
} mtk_function_info_t;

typedef struct mtk_module_info {
    const char *name;
    bool (*start)(argument_value_list_t *args);
    void (*stop)();
    mtk_function_info_t *functions;
} mtk_module_info_t;

typedef enum {
    mtk_event_module_started = 1,
    mtk_event_module_stopped,
    mtk_event_module_start_failed,
} mtk_event_t;

typedef void (* mtk_inform_handler_fn_t) (mtk_module_t *module, mtk_event_t event);

pcb_t *mtk_getPcb();
peer_info_t *mtk_getSysbus();
const char *mtk_getName();

mtk_so_t *mtk_so_open(const char *path, argument_value_list_t *args);
const char *mtk_so_error();
void *mtk_so_handle(mtk_so_t *so);
int mtk_so_close(mtk_so_t *so);

argument_value_list_t *mtk_rpc_arguments(mtk_rpc_t *rpc);
uint32_t mtk_rpc_attributes(mtk_rpc_t *rpc);
variant_t *mtk_rpc_returnValue(mtk_rpc_t *rpc);
void mtk_rpc_addError(mtk_rpc_t *rpc, uint32_t code, const char *description, const char *info);

mtk_module_t *mtk_module_register(mtk_module_info_t *info);
mtk_module_t *mtk_module_register_ex(mtk_module_info_t *info, void *userdata);
void mtk_module_setUserdata(mtk_module_t *module, void *userdata);
void *mtk_module_getUserdata(mtk_module_t *module);
const char *mtk_module_getName(mtk_module_t *module);


mtk_notification_t *mtk_notification_create(mtk_module_t *module, uint32_t type, const char *name);
void mtk_notification_addParameter(mtk_notification_t *notification, const char *name, variant_t *value);
void mtk_notification_send(mtk_notification_t *notification);

void mtk_funcHandler(notification_t *notification);

bool mtk_init(app_config_t *config, argument_value_list_t *args);
bool mtk_add_informHandler(mtk_inform_handler_fn_t fn);
bool mtk_remove_informHandler(mtk_inform_handler_fn_t fn);

void mtk_start();
void mtk_stop();
void mtk_unload();

void mtk_cleanup();

#ifdef __cplusplus
}
#endif

#endif
